/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.blockentity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.EnergyTransmitterBlock;
import cn.leolezury.eternalstarlight.common.block.entity.EnergyTransmitterBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnergyTransmitterRenderer<T extends EnergyTransmitterBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation ENERGY_TRANSMITTER_TEXTURE = EternalStarlight.id("textures/entity/energy_transmitter.png");

    public EnergyTransmitterRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int receiverPower;
        Vec3i inputOffset = ((EnergyTransmitterBlockEntity)((Object)blockEntity)).getInputOffset();
        BlockState state = blockEntity.getBlockState();
        BlockState inputState = ((EnergyTransmitterBlockEntity)((Object)blockEntity)).getInputState();
        Direction inputFacing = inputState.hasProperty((Property)EnergyTransmitterBlock.FACING) ? (Direction)inputState.getValue((Property)EnergyTransmitterBlock.FACING) : Direction.UP;
        int n = receiverPower = state.hasProperty((Property)EnergyTransmitterBlock.POWER) ? (Integer)state.getValue((Property)EnergyTransmitterBlock.POWER) : 0;
        if (!inputOffset.equals((Object)Vec3i.ZERO) && receiverPower > 0) {
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            Vec3 sight = camera.getPosition().subtract(blockEntity.getBlockPos().getCenter());
            Vec3 start = new Vec3(0.5, 0.5, 0.5).add(new Vec3(((Direction)state.getValue((Property)EnergyTransmitterBlock.FACING)).step()).scale(-0.125));
            Vec3 end = Vec3.atCenterOf((Vec3i)inputOffset).add(new Vec3(inputFacing.step()).scale(-0.125));
            Vec3 sideOffset = end.subtract(start).cross(sight).normalize().scale(0.03125);
            PoseStack.Pose pose = poseStack.last();
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)ENERGY_TRANSMITTER_TEXTURE));
            vertexConsumer.addVertex(pose, start.add(sideOffset).toVector3f()).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, start.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, end.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, end.add(sideOffset).toVector3f()).setColor(-1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        }
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }
}

