/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.blockentity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.entity.AbstractDuskLightBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DuskLightRenderer<T extends AbstractDuskLightBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation DUSK_BEAM_TEXTURE = EternalStarlight.id("textures/entity/dusk_beam.png");

    public DuskLightRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        for (Direction direction : Direction.values()) {
            float progress = Mth.lerp((float)partialTicks, (float)((AbstractDuskLightBlockEntity)blockEntity).getOldBeamProgresses().getOrDefault((Object)direction, 0.0f), (float)((AbstractDuskLightBlockEntity)blockEntity).getBeamProgresses().getOrDefault((Object)direction, 0.0f));
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            Vec3 sight = camera.getPosition().subtract(blockEntity.getBlockPos().getCenter());
            Vec3 start = new Vec3(0.5, 0.5, 0.5).add(new Vec3((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ()).scale(0.5));
            Vec3 end = start.add(new Vec3((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ()).scale((double)(progress * 30.0f)));
            Vec3 sideOffset = end.subtract(start).cross(sight).normalize().scale(0.25);
            PoseStack.Pose pose = poseStack.last();
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)DUSK_BEAM_TEXTURE));
            vertexConsumer.addVertex(pose, start.add(sideOffset).toVector3f()).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, start.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, end.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, end.add(sideOffset).toVector3f()).setColor(-1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        }
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }
}

