/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.blockentity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.AlloyFurnaceBlock;
import cn.leolezury.eternalstarlight.common.block.WeatheringGolemSteel;
import cn.leolezury.eternalstarlight.common.block.entity.AlloyFurnaceBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AlloyFurnaceRenderer
implements BlockEntityRenderer<AlloyFurnaceBlockEntity> {
    private final AlloyFurnaceModel furnaceModel;
    private static final ResourceLocation FURNACE_TEXTURE = EternalStarlight.id("textures/entity/alloy_furnace/alloy_furnace.png");
    private static final ResourceLocation OXIDIZED_FURNACE_TEXTURE = EternalStarlight.id("textures/entity/alloy_furnace/oxidized_alloy_furnace.png");
    private static final List<ResourceLocation> LIT_TEXTURES = List.of(EternalStarlight.id("textures/entity/alloy_furnace/alloy_furnace_lit_0.png"), EternalStarlight.id("textures/entity/alloy_furnace/alloy_furnace_lit_1.png"), EternalStarlight.id("textures/entity/alloy_furnace/alloy_furnace_lit_2.png"));
    private static final List<ResourceLocation> FAN_TEXTURES = List.of(EternalStarlight.id("textures/entity/alloy_furnace/alloy_furnace_fan_0.png"), EternalStarlight.id("textures/entity/alloy_furnace/alloy_furnace_fan_1.png"));
    private static final List<ResourceLocation> OXIDIZED_FAN_TEXTURES = List.of(EternalStarlight.id("textures/entity/alloy_furnace/oxidized_alloy_furnace_fan_0.png"), EternalStarlight.id("textures/entity/alloy_furnace/oxidized_alloy_furnace_fan_1.png"));

    public AlloyFurnaceRenderer(BlockEntityRendererProvider.Context context) {
        this.furnaceModel = new AlloyFurnaceModel(context.bakeLayer(AlloyFurnaceModel.LAYER_LOCATION));
    }

    public void render(AlloyFurnaceBlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        WeatheringGolemSteel weathering;
        boolean oxidized;
        BlockState state = blockEntity.getBlockState();
        Block block = state.getBlock();
        boolean bl = oxidized = block instanceof WeatheringGolemSteel && (weathering = (WeatheringGolemSteel)block).isOxidized();
        if ((Integer)state.getValue((Property)AlloyFurnaceBlock.X_OFFSET) == 0 && (Integer)state.getValue((Property)AlloyFurnaceBlock.Y_OFFSET) == 0 && (Integer)state.getValue((Property)AlloyFurnaceBlock.Z_OFFSET) == 1) {
            stack.pushPose();
            stack.scale(-1.0f, -1.0f, 1.0f);
            stack.translate(-0.5f, -1.5f, 0.5f);
            float overheatAmplitude = Mth.lerp((float)partialTicks, (float)blockEntity.oldClientOverheatAmplitude, (float)blockEntity.clientOverheatAmplitude);
            float animationTicks = Mth.lerp((float)partialTicks, (float)blockEntity.oldClientAnimationTicks, (float)blockEntity.clientAnimationTicks);
            stack.mulPose(Axis.YP.rotationDegrees(((Direction)blockEntity.getBlockState().getValue((Property)AlloyFurnaceBlock.FACING)).toYRot() + 180.0f));
            int lightWithOverheat = light;
            if (overheatAmplitude > 0.0f) {
                lightWithOverheat = LightTexture.pack((int)Mth.ceil((float)Mth.lerp((float)overheatAmplitude, (float)LightTexture.block((int)light), (float)15.0f)), (int)Mth.ceil((float)Mth.lerp((float)overheatAmplitude, (float)LightTexture.sky((int)light), (float)15.0f)));
                stack.scale(1.0f + (float)Math.cos((double)animationTicks * 3.25) * overheatAmplitude * 0.02f, 1.0f + (float)Math.cos((double)animationTicks * 2.25) * overheatAmplitude * 0.02f, 1.0f + (float)Math.cos((double)animationTicks * 3.25) * overheatAmplitude * 0.02f);
            }
            int overheatColor = FastColor.ARGB32.lerp((float)overheatAmplitude, (int)-1, (int)-1150908);
            this.furnaceModel.renderToBuffer(stack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)(oxidized ? OXIDIZED_FURNACE_TEXTURE : FURNACE_TEXTURE))), lightWithOverheat, overlay, overheatColor);
            this.furnaceModel.renderToBuffer(stack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)(oxidized ? OXIDIZED_FAN_TEXTURES : FAN_TEXTURES).get((blockEntity.isCooling() ? blockEntity.clientAnimationTicks / 2 : 0) % (oxidized ? OXIDIZED_FAN_TEXTURES : FAN_TEXTURES).size()))), lightWithOverheat, overlay, overheatColor);
            if (blockEntity.isLit()) {
                this.furnaceModel.renderToBuffer(stack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)LIT_TEXTURES.get(blockEntity.clientAnimationTicks / 2 % LIT_TEXTURES.size()))), 0xF000F0, overlay);
            }
            stack.popPose();
        }
    }

    public boolean shouldRenderOffScreen(AlloyFurnaceBlockEntity blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public static final class AlloyFurnaceModel
    extends Model {
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("alloy_furnace"), "main");
        public final ModelPart root;

        public AlloyFurnaceModel(ModelPart root) {
            super(RenderType::entityCutoutNoCull);
            this.root = root.getChild("root");
        }

        public static LayerDefinition createLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(-24.0f, -32.0f, -8.0f, 36.0f, 32.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(0, 64).addBox(12.0f, -28.0f, 2.0f, 12.0f, 28.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(48, 76).addBox(15.0f, -32.0f, 5.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(48, 64).addBox(-1.0f, -38.0f, 5.0f, 22.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 156).addBox(-11.0f, -40.0f, 9.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 120).addBox(-21.0f, -44.0f, -1.0f, 10.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 104).addBox(-22.0f, -48.0f, -2.0f, 12.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 142).addBox(-12.0f, -44.0f, 8.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)meshdefinition, (int)192, (int)192);
        }

        public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
            this.root.render(stack, consumer, light, overlay, color);
        }
    }
}

