/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ESClientHandler;
import cn.leolezury.eternalstarlight.common.particle.RingExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.util.Color;
import cn.leolezury.eternalstarlight.common.util.Easing;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class RingExplosionParticle
extends SimpleAnimatedParticle {
    private final float scale;

    protected RingExplosionParticle(ClientLevel clientLevel, double x, double y, double z, double dx, double dy, double dz, int fromColor, int toColor, float scale, SpriteSet spriteSet) {
        super(clientLevel, x, y, z, spriteSet, 0.0f);
        this.xd = dx;
        this.yd = dy;
        this.zd = dz;
        this.quadSize = 1.5f;
        this.lifetime = 60;
        this.setColor(fromColor);
        this.setFadeColor(toColor);
        this.scale = scale;
        this.setSpriteFromAge(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        this.alpha = Easing.OUT_CUBIC.interpolate(Math.min(((float)this.age + partialTicks) / (float)this.lifetime, 1.0f), 1.0f, 0.0f);
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotateX(1.5707964f);
        VertexConsumer vertexConsumer = ESClientHandler.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.PARTICLE);
        this.renderRotatedQuad(vertexConsumer, camera, quaternionf, partialTicks);
        quaternionf = new Quaternionf();
        quaternionf.rotateY((float)(-Math.PI)).rotateX(-1.5707964f);
        this.renderRotatedQuad(vertexConsumer, camera, quaternionf, partialTicks);
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Easing.OUT_QUINT.interpolate(((float)this.age + partialTicks) / (float)this.lifetime, this.scale / 10.0f, this.scale);
    }

    public static class Provider
    implements ParticleProvider<RingExplosionParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(RingExplosionParticleOptions options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new RingExplosionParticle(level, x, y, z, dx, dy, dz, Color.rgbd(options.fromColor().x / 255.0f, options.fromColor().y / 255.0f, options.fromColor().z / 255.0f).rgb(), Color.rgbd(options.toColor().x / 255.0f, options.toColor().y / 255.0f, options.toColor().z / 255.0f).rgb(), options.scale(), this.sprites);
        }
    }
}

