/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ESClientHandler;
import cn.leolezury.eternalstarlight.common.particle.OrbitalTrailParticleOptions;
import cn.leolezury.eternalstarlight.common.util.Color;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OrbitalTrailParticle
extends Particle {
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");
    private final TrailEffect effect = new TrailEffect(0.125f, 4);
    private final int fromColor;
    private final int toColor;
    private final float radius;
    private final float rotSpeed;
    private final Entity owner;
    private double cx;
    private double cy;
    private double cz;
    private float yaw;

    protected OrbitalTrailParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int lifetime, int owner, int fromColor, int toColor, float radius, float rotSpeed, float alpha) {
        super(level, x, y, z);
        this.lifetime = lifetime;
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.fromColor = fromColor;
        this.toColor = toColor;
        this.radius = radius;
        this.rotSpeed = rotSpeed;
        this.alpha = alpha;
        this.cx = x;
        this.cy = y;
        this.cz = z;
        this.owner = level.getEntity(owner);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.cx += this.xd;
        this.cy += this.yd;
        this.cz += this.zd;
        if (this.owner != null) {
            this.cx = this.owner.getX();
            this.cz = this.owner.getZ();
        }
        this.yaw += this.rotSpeed;
        this.yaw = Mth.wrapDegrees((float)this.yaw);
        Vec3 pos = ESMathUtil.rotationToPosition(new Vec3(this.cx, this.cy, this.cz), this.radius, 0.0f, this.yaw);
        this.x = pos.x();
        this.y = pos.y();
        this.z = pos.z();
        this.effect.update(new Vec3(this.xo, this.yo, this.zo));
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        float progress = Math.min((float)this.age + partialTicks, (float)this.lifetime) / (float)this.lifetime;
        Color color = Color.rgbi((int)Mth.lerp((float)progress, (float)Color.rgb(this.fromColor).r(), (float)Color.rgb(this.toColor).r()), (int)Mth.lerp((float)progress, (float)Color.rgb(this.fromColor).g(), (float)Color.rgb(this.toColor).g()), (int)Mth.lerp((float)progress, (float)Color.rgb(this.fromColor).b(), (float)Color.rgb(this.toColor).b()));
        float a = Mth.lerp((float)((float)(Math.abs((double)progress - 0.5) * 2.0)), (float)this.alpha, (float)0.0f);
        PoseStack stack = new PoseStack();
        float x = (float)Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x);
        float y = (float)Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y);
        float z = (float)Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z);
        stack.pushPose();
        stack.translate(-camera.getPosition().x, -camera.getPosition().y, -camera.getPosition().z);
        this.effect.prepareRender(new Vec3((double)x, (double)y, (double)z), partialTicks);
        this.effect.render(ESClientHandler.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.entityTranslucentGlow(TRAIL_TEXTURE)), stack, color.rf(), color.gf(), color.bf(), a * 5.0f, 0xF000F0);
        stack.popPose();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public static class Provider
    implements ParticleProvider<OrbitalTrailParticleOptions> {
        public Provider(SpriteSet spriteSet) {
        }

        public Particle createParticle(OrbitalTrailParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new OrbitalTrailParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options.lifetime(), options.owner(), Color.rgbd(options.fromColor().x / 255.0f, options.fromColor().y / 255.0f, options.fromColor().z / 255.0f).rgb(), Color.rgbd(options.toColor().x / 255.0f, options.toColor().y / 255.0f, options.toColor().z / 255.0f).rgb(), options.radius(), options.rotSpeed(), options.alpha());
        }
    }
}

