/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.ESModelUtil;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.TheGatekeeperAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.HumanoidArm;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TheGatekeeperModel<T extends TheGatekeeper>
extends AnimatedEntityModel<T>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("the_gatekeeper"), "main");
    public static final ModelLayerLocation SLIM_LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("the_gatekeeper_slim"), "main");
    public static final ModelLayerLocation OUTER_LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("the_gatekeeper"), "outer");
    public static final ModelLayerLocation SLIM_OUTER_LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("the_gatekeeper_slim"), "outer");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftHand;
    private final ModelPart rightHand;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final boolean slim;
    public final List<String> allPartNames;
    public float alphaFactor = 1.0f;

    public TheGatekeeperModel(ModelPart root, boolean slim) {
        this.root = root.getChild("root");
        this.body = root.getChild("root").getChild("body");
        this.head = this.body.getChild("head");
        this.leftArm = this.body.getChild("left_arm");
        this.rightArm = this.body.getChild("right_arm");
        this.leftHand = this.leftArm.getChild("left_hand");
        this.rightHand = this.rightArm.getChild("right_hand");
        this.leftLeg = root.getChild("root").getChild("left_leg");
        this.rightLeg = root.getChild("root").getChild("right_leg");
        this.slim = slim;
        this.allPartNames = Stream.concat(Stream.of("root"), ESModelUtil.getAllPartNames(this.root)).toList();
    }

    public static LayerDefinition createBodyLayer(boolean slim) {
        return TheGatekeeperModel.createBodyLayer(slim, 0.0f);
    }

    public static LayerDefinition createBodyLayer(boolean slim, float deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(deformation)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, -24.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(deformation + 0.25f)), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        if (slim) {
            leftArm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(deformation)), PartPose.offset((float)5.0f, (float)-10.0f, (float)0.0f));
            leftArm.addOrReplaceChild("left_hand", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)8.0f, (float)0.0f));
            leftArm.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(deformation + 0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            rightArm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(deformation)), PartPose.offset((float)-5.0f, (float)-10.0f, (float)0.0f));
            rightArm.addOrReplaceChild("right_hand", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)8.0f, (float)0.0f));
            rightArm.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(deformation + 0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        } else {
            leftArm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(deformation)), PartPose.offset((float)5.0f, (float)-10.0f, (float)0.0f));
            leftArm.addOrReplaceChild("left_hand", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)8.0f, (float)0.0f));
            leftArm.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(deformation + 0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            rightArm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(deformation)), PartPose.offset((float)-5.0f, (float)-10.0f, (float)0.0f));
            rightArm.addOrReplaceChild("right_hand", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)8.0f, (float)0.0f));
            rightArm.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(deformation + 0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        }
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(deformation)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(deformation + 0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(deformation)), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        leftLeg.addOrReplaceChild("left_pants", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(deformation + 0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(deformation)), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        rightLeg.addOrReplaceChild("right_pants", CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(deformation + 0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        if (!((ESBoss)entity).isActivated()) {
            this.root.y += 10.0f;
            ModelPart arm = this.rightArm;
            arm.xRot += -0.62831855f;
            arm = this.leftArm;
            arm.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        } else {
            this.animateWalk(entity.getMainHandItem().isEmpty() ? TheGatekeeperAnimation.WALK_1 : TheGatekeeperAnimation.WALK_2, limbSwing, limbSwingAmount, 2.5f, 1.2f);
            if (((ESBoss)entity).getBehaviorTicks() >= 0 && ((ESBoss)entity).getBehaviorState() != 0 && ((TheGatekeeper)entity).deathTime <= 0) {
                int state = ((ESBoss)entity).getBehaviorState();
                switch (state) {
                    case 1: {
                        this.leftArm.resetPose();
                        this.rightArm.resetPose();
                        this.animate(((TheGatekeeper)entity).meleeAnimationStateA, TheGatekeeperAnimation.ATTACK_1, ageInTicks);
                        this.animate(((TheGatekeeper)entity).meleeAnimationStateB, TheGatekeeperAnimation.ATTACK_2, ageInTicks);
                        this.animate(((TheGatekeeper)entity).meleeAnimationStateC, TheGatekeeperAnimation.ATTACK_3, ageInTicks);
                        break;
                    }
                    case 2: {
                        this.animate(((TheGatekeeper)entity).dodgeAnimationState, TheGatekeeperAnimation.DODGE, ageInTicks);
                        break;
                    }
                    case 3: {
                        this.leftArm.resetPose();
                        this.rightArm.resetPose();
                        this.animate(((TheGatekeeper)entity).dashAnimationState, TheGatekeeperAnimation.DASH, ageInTicks);
                        break;
                    }
                    case 4: {
                        this.animate(((TheGatekeeper)entity).castFireballAnimationState, TheGatekeeperAnimation.CAST_FIREBALL, ageInTicks);
                        break;
                    }
                    case 5: {
                        this.leftArm.resetPose();
                        this.rightArm.resetPose();
                        this.animate(((TheGatekeeper)entity).danceFightAnimationState, TheGatekeeperAnimation.DANCE_FIGHT, ageInTicks);
                        break;
                    }
                    case 6: {
                        this.leftArm.resetPose();
                        this.rightArm.resetPose();
                        this.animate(((TheGatekeeper)entity).swingSwordAnimationState, TheGatekeeperAnimation.SWING_SWORD, ageInTicks);
                        break;
                    }
                    case 7: {
                        this.leftArm.resetPose();
                        this.rightArm.resetPose();
                        this.animate(((TheGatekeeper)entity).comboAnimationState, TheGatekeeperAnimation.COMBO, ageInTicks);
                    }
                }
            }
            this.animate(((TheGatekeeper)entity).idleAnimationState, TheGatekeeperAnimation.IDLE, ageInTicks, 0.05f, 1.0f);
        }
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        this.root.translateAndRotate(stack);
        this.body.translateAndRotate(stack);
        ModelPart armPart = arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
        ModelPart handPart = arm == HumanoidArm.LEFT ? this.leftHand : this.rightHand;
        armPart.translateAndRotate(stack);
        if (this.slim) {
            float f = 0.5f * (float)(arm == HumanoidArm.RIGHT ? 1 : -1);
            handPart.x += f;
            handPart.translateAndRotate(stack);
            handPart.x -= f;
        } else {
            handPart.translateAndRotate(stack);
        }
        stack.translate(0.0, -0.625, 0.0);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    public RenderType renderType(ResourceLocation resourceLocation) {
        return RenderType.entityTranslucent((ResourceLocation)resourceLocation);
    }

    @Override
    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        super.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, FastColor.ARGB32.color((int)Math.round((float)FastColor.ARGB32.alpha((int)color) * this.alphaFactor), (int)FastColor.ARGB32.red((int)color), (int)FastColor.ARGB32.green((int)color), (int)FastColor.ARGB32.blue((int)color)));
    }
}

