/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.attack.TentacleSpike;
import cn.leolezury.eternalstarlight.common.entity.attack.Whip;
import cn.leolezury.eternalstarlight.common.util.Easing;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TentacleSpikeModel<T extends TentacleSpike>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("tentacle_spike"), "main");
    private static final int NUM_SEGMENTS = 20;
    private static final int NUM_SPIKED_SEGMENTS = 5;
    private final ModelPart root;
    private final ModelPart[] segments;

    public TentacleSpikeModel(ModelPart root) {
        this.root = root.getChild("root");
        ModelPart[] parts = new ModelPart[20];
        ModelPart last = this.root;
        for (int i = 0; i < 20; ++i) {
            parts[i] = last = last.getChild("segment" + (i + 1));
        }
        this.segments = parts;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition last = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        int spikeCount = 0;
        for (int i = 0; i < 20; ++i) {
            last = last.addOrReplaceChild("segment" + (i + 1), CubeListBuilder.create().texOffs(0, 12).addBox(-2.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)(i == 0 ? 0.0f : -12.0f), (float)0.0f));
            if (i < 15) continue;
            last.addOrReplaceChild("spike" + (spikeCount + 1), CubeListBuilder.create().texOffs(0, -16).addBox(0.0f, -12.0f, -8.0f, 0.0f, 12.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
            last.addOrReplaceChild("spike" + (spikeCount + 2), CubeListBuilder.create().texOffs(0, -16).addBox(0.0f, -12.0f, -8.0f, 0.0f, 12.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
            spikeCount += 2;
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        float progress = Mth.clamp((float)(((Whip)((Object)entity)).getAnimationTicks(Mth.frac((float)ageInTicks)) / (float)((TentacleSpike)((Object)entity)).getLifespan()), (float)0.0f, (float)1.0f);
        for (int i = 0; i < 20; ++i) {
            ModelPart segment = this.segments[i];
            segment.xRot = Mth.lerp((float)progress, (float)(120.0f / (float)(i + 1)), (float)(-120.0f / (float)(i + 1))) * ((float)Math.PI / 180);
            if (i != 0) continue;
            float scale = Easing.IN_OUT_SINE.calculate(1.0f - Math.abs(progress - 0.5f) * 2.0f);
            segment.yScale = segment.zScale = scale * 0.75f;
            segment.xScale = segment.zScale;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

