/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.ESModelUtil;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.StarlightGolemAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class StarlightGolemModel<T extends StarlightGolem>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("starlight_golem"), "main");
    private final ModelPart root;
    private final ModelPart head;
    public final List<String> allPartNames;
    public float alphaFactor = 1.0f;

    public StarlightGolemModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("upper").getChild("head");
        this.allPartNames = Stream.concat(Stream.of("root"), ESModelUtil.getAllPartNames(this.root)).toList();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition upper = partdefinition.addOrReplaceChild("upper", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        upper.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(84, 83).addBox(-8.0f, -3.0f, -4.0f, 7.0f, 27.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -3.0f, -3.0f, 2.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 70).addBox(-8.0f, 24.0f, -4.0f, 7.0f, 5.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-11.0f, (float)-29.0f, (float)0.0f));
        upper.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 91).addBox(1.0f, -3.0f, -4.0f, 7.0f, 27.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 46).addBox(-1.0f, -3.0f, -3.0f, 2.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(46, 70).addBox(1.0f, 24.0f, -4.0f, 7.0f, 5.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)11.0f, (float)-29.0f, (float)0.0f));
        upper.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -15.0f, -8.0f, 20.0f, 30.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-19.0f, (float)0.0f));
        upper.addOrReplaceChild("head", CubeListBuilder.create().texOffs(68, 33).addBox(-7.0f, -10.5f, -6.5f, 14.0f, 13.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-30.5f, (float)-3.5f));
        partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 46).addBox(-12.0f, -4.0f, -10.0f, 24.0f, 4.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (((ESBoss)entity).getPhase() == 1) {
            AtomicInteger offsetCount = new AtomicInteger();
            this.root().getAllParts().forEach(part -> part.offsetPos(new Vector3f((float)Math.cos((double)entity.tickCount * 3.25 + (double)offsetCount.getAndIncrement() * 1.5), (float)Math.cos((double)entity.tickCount * 2.25 + (double)offsetCount.getAndIncrement() * 1.5), (float)Math.cos((double)entity.tickCount * 3.25 + (double)offsetCount.getAndIncrement() * 1.5)).normalize().mul(0.2f)));
        }
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        if (((ESBoss)entity).getBehaviorTicks() >= 0 && ((ESBoss)entity).getBehaviorState() != 0 && ((StarlightGolem)entity).deathAnimationTime <= 0) {
            int state = ((ESBoss)entity).getBehaviorState();
            switch (state) {
                case 1: {
                    this.animate(((StarlightGolem)entity).laserBeamAnimationState, StarlightGolemAnimation.LASER_BEAM, ageInTicks);
                    break;
                }
                case 2: {
                    this.animate(((StarlightGolem)entity).summonFlameAnimationState, StarlightGolemAnimation.ENERGIZED_FLAME, ageInTicks);
                    break;
                }
                case 3: {
                    this.animate(((StarlightGolem)entity).smashAnimationState, ((ESBoss)entity).getPhase() == 1 ? StarlightGolemAnimation.SMASH_LEAP : StarlightGolemAnimation.SMASH, ageInTicks);
                    break;
                }
                case 4: {
                    this.animate(((StarlightGolem)entity).chargeStartAnimationState, StarlightGolemAnimation.CHARGE_START, ageInTicks);
                    break;
                }
                case 5: {
                    this.animate(((StarlightGolem)entity).chargeAnimationState, StarlightGolemAnimation.CHARGE, ageInTicks);
                    break;
                }
                case 6: {
                    this.animate(((StarlightGolem)entity).chargeEndAnimationState, StarlightGolemAnimation.CHARGE_END, ageInTicks);
                }
            }
        }
        if (((StarlightGolem)entity).deathAnimationTime > 0) {
            this.animate(((StarlightGolem)entity).deathAnimationState, StarlightGolemAnimation.DEATH, ageInTicks);
        }
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root().render(poseStack, vertexConsumer, packedLight, packedOverlay, FastColor.ARGB32.color((int)Math.round((float)FastColor.ARGB32.alpha((int)color) * this.alphaFactor), (int)FastColor.ARGB32.red((int)color), (int)FastColor.ARGB32.green((int)color), (int)FastColor.ARGB32.blue((int)color)));
    }
}

