/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.ESModelUtil;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.PermafrostAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.Permafrost;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PermafrostModel<T extends Permafrost>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("permafrost"), "main");
    private final ModelPart root;
    private final ModelPart head;
    public final ModelPart lower;
    public final ModelPart armature;
    public final List<String> allPartNames;
    public float alphaFactor = 1.0f;

    public PermafrostModel(ModelPart root) {
        this.root = root.getChild("root");
        this.head = root.getChild("root").getChild("head");
        this.lower = root.getChild("root").getChild("lower");
        this.armature = root.getChild("root").getChild("lower").getChild("armature");
        this.allPartNames = Stream.concat(Stream.of("root"), ESModelUtil.getAllPartNames(this.root)).toList();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition lower = root.addOrReplaceChild("lower", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition armature = lower.addOrReplaceChild("armature", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, 3.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 8).addBox(-2.0f, 9.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        armature.addOrReplaceChild("armature1", CubeListBuilder.create().texOffs(0, 57).mirror().addBox(-9.0f, -6.5f, 0.0f, 9.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)3.5f, (float)-1.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        armature.addOrReplaceChild("armature2", CubeListBuilder.create().texOffs(0, 57).addBox(0.0f, -6.5f, 0.0f, 9.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)3.5f, (float)-1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        armature.addOrReplaceChild("armature3", CubeListBuilder.create().texOffs(0, 57).addBox(0.0f, -6.5f, 0.0f, 9.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)3.5f, (float)1.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        armature.addOrReplaceChild("armature4", CubeListBuilder.create().texOffs(0, 57).mirror().addBox(-9.0f, -6.5f, 0.0f, 9.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)3.5f, (float)1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition wheel = lower.addOrReplaceChild("wheel", CubeListBuilder.create().texOffs(40, 16).addBox(-4.0f, -1.2f, -4.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 20).addBox(-4.0f, -1.2f, 2.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(52, 24).addBox(2.0f, -1.2f, -2.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 24).addBox(-4.0f, -1.2f, -2.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(18, 52).addBox(0.0f, -1.2f, -2.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(18, 56).addBox(-2.0f, -1.2f, 0.0f, 4.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(18, 55).addBox(0.0f, -1.2f, -7.0f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(18, 58).addBox(0.0f, -1.2f, 4.0f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(18, 61).addBox(-7.0f, -1.2f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(18, 58).addBox(4.0f, -1.2f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.2f, (float)0.0f));
        PartDefinition rightChainCenter = wheel.addOrReplaceChild("right_chain_center", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.8f, (float)0.0f));
        PartDefinition rightChain = rightChainCenter.addOrReplaceChild("right_chain", CubeListBuilder.create(), PartPose.offset((float)-5.5f, (float)0.0f, (float)0.0f));
        PartDefinition rightChain1 = rightChain.addOrReplaceChild("right_chain1", CubeListBuilder.create().texOffs(48, -1).addBox(0.0f, -0.5f, -1.5f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition rightChain2 = rightChain1.addOrReplaceChild("right_chain2", CubeListBuilder.create().texOffs(48, 2).addBox(-1.5f, -0.5f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        rightChain2.addOrReplaceChild("right_rod", CubeListBuilder.create().texOffs(40, 30).addBox(-1.5f, 1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(52, 31).addBox(-1.0f, 3.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 3).addBox(0.0f, -0.5f, -1.5f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition leftChainCenter = wheel.addOrReplaceChild("left_chain_center", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.8f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition leftChain = leftChainCenter.addOrReplaceChild("left_chain", CubeListBuilder.create(), PartPose.offset((float)-5.5f, (float)0.0f, (float)0.0f));
        PartDefinition leftChain1 = leftChain.addOrReplaceChild("left_chain1", CubeListBuilder.create().texOffs(48, -1).addBox(0.0f, -0.5f, -1.5f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition leftChain2 = leftChain1.addOrReplaceChild("left_chain2", CubeListBuilder.create().texOffs(48, 2).addBox(-1.5f, -0.5f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        leftChain2.addOrReplaceChild("left_rod", CubeListBuilder.create().texOffs(40, 30).addBox(-1.5f, 1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(52, 31).addBox(-1.0f, 3.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 3).addBox(0.0f, -0.5f, -1.5f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition forwardChainCenter = wheel.addOrReplaceChild("forward_chain_center", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.8f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition forwardChain = forwardChainCenter.addOrReplaceChild("forward_chain", CubeListBuilder.create(), PartPose.offset((float)-5.5f, (float)0.0f, (float)0.0f));
        PartDefinition forwardChain1 = forwardChain.addOrReplaceChild("forward_chain1", CubeListBuilder.create().texOffs(48, -1).addBox(0.0f, -0.5f, -1.5f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition forwardChain2 = forwardChain1.addOrReplaceChild("forward_chain2", CubeListBuilder.create().texOffs(48, 2).addBox(-1.5f, -0.5f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        forwardChain2.addOrReplaceChild("forward_rod", CubeListBuilder.create().texOffs(40, 30).addBox(-1.5f, 1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(52, 31).addBox(-1.0f, 3.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 3).addBox(0.0f, -0.5f, -1.5f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition backwardChainCenter = wheel.addOrReplaceChild("backward_chain_center", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.8f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition backwardChain = backwardChainCenter.addOrReplaceChild("backward_chain", CubeListBuilder.create(), PartPose.offset((float)-5.5f, (float)0.0f, (float)0.0f));
        PartDefinition backwardChain1 = backwardChain.addOrReplaceChild("backward_chain1", CubeListBuilder.create().texOffs(48, -1).addBox(0.0f, -0.5f, -1.5f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition backwardChain2 = backwardChain1.addOrReplaceChild("backward_chain2", CubeListBuilder.create().texOffs(48, 2).addBox(-1.5f, -0.5f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        backwardChain2.addOrReplaceChild("backward_rod", CubeListBuilder.create().texOffs(40, 30).addBox(-1.5f, 1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(52, 31).addBox(-1.0f, 3.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 3).addBox(0.0f, -0.5f, -1.5f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 20).addBox(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.5f)).texOffs(0, 0).addBox(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.animate(((Permafrost)entity).idleAnimationState, PermafrostAnimation.IDLE, ageInTicks);
        if (((ESBoss)entity).getBehaviorTicks() >= 0 && ((ESBoss)entity).getBehaviorState() != 0 && ((Permafrost)entity).deathTime <= 0) {
            int state = ((ESBoss)entity).getBehaviorState();
            switch (state) {
                case 1: {
                    this.animate(((Permafrost)entity).meleeAnimationState, PermafrostAnimation.MELEE, ageInTicks);
                    break;
                }
                case 2: {
                    this.animate(((Permafrost)entity).meleeTransitionAnimationState, PermafrostAnimation.MELEE_TRANSITION, ageInTicks);
                    break;
                }
                case 3: {
                    this.animate(((Permafrost)entity).meleeEndAnimationState, PermafrostAnimation.MELEE_END, ageInTicks);
                    break;
                }
                case 4: {
                    this.animate(((Permafrost)entity).rangedAnimationState, PermafrostAnimation.RANGED, ageInTicks);
                    break;
                }
                case 5: {
                    this.animate(((Permafrost)entity).sneezeAnimationState, PermafrostAnimation.RANGED_SNEEZE, ageInTicks);
                }
            }
        }
    }

    public RenderType renderType(ResourceLocation resourceLocation) {
        return RenderType.entityTranslucent((ResourceLocation)resourceLocation);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root().render(poseStack, vertexConsumer, packedLight, packedOverlay, FastColor.ARGB32.color((int)Math.round((float)FastColor.ARGB32.alpha((int)color) * this.alphaFactor), (int)FastColor.ARGB32.red((int)color), (int)FastColor.ARGB32.green((int)color), (int)FastColor.ARGB32.blue((int)color)));
    }
}

