/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model;

import cn.leolezury.eternalstarlight.common.util.ModelPartPose;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class ESModelUtil {
    private static final MultiBufferSource DUMMY_BUFFER = new MultiBufferSource(){

        public VertexConsumer getBuffer(RenderType renderType) {
            return new VertexConsumer(this){

                public VertexConsumer addVertex(float x, float y, float z) {
                    return this;
                }

                public VertexConsumer setColor(int red, int green, int blue, int alpha) {
                    return this;
                }

                public VertexConsumer setUv(float u, float v) {
                    return this;
                }

                public VertexConsumer setUv1(int u, int v) {
                    return this;
                }

                public VertexConsumer setUv2(int u, int v) {
                    return this;
                }

                public VertexConsumer setNormal(float normalX, float normalY, float normalZ) {
                    return this;
                }
            };
        }
    };

    public static Vec3 getModelPartWorldPosition(Entity entity, float yaw, List<ModelPart> parts) {
        double d;
        PoseStack stack = new PoseStack();
        stack.translate(entity.getX(), entity.getY(), entity.getZ());
        stack.mulPose(new Quaternionf().rotationY((-yaw + 180.0f) * ((float)Math.PI / 180)));
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(0.0f, -1.5f, 0.0f);
        for (ModelPart part : parts) {
            part.translateAndRotate(stack);
        }
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f).mul((Matrix4fc)stack.last().pose());
        Vec3 pos = new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
        Vec3 subtract = pos.subtract(entity.position());
        Vec3 vec3 = entity.position();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            d = living.getScale();
        } else {
            d = 1.0;
        }
        return vec3.add(subtract.scale(d));
    }

    public static Optional<Vec3> getThirdPersonPlayerHandPosition(Player player, EntityRenderDispatcher renderDispatcher, float yaw, float partialTick, HumanoidArm arm, Vec3 offset) {
        AbstractClientPlayer clientPlayer;
        EntityRenderer entityRenderer;
        if (player instanceof AbstractClientPlayer && (entityRenderer = renderDispatcher.getRenderer((Entity)(clientPlayer = (AbstractClientPlayer)player))) instanceof PlayerRenderer) {
            PlayerRenderer renderer = (PlayerRenderer)entityRenderer;
            PoseStack stack = new PoseStack();
            renderer.render(clientPlayer, yaw, partialTick, stack, DUMMY_BUFFER, 0xF000F0);
            PlayerModel model = (PlayerModel)renderer.getModel();
            stack.translate(Mth.lerp((double)partialTick, (double)player.xo, (double)player.getX()), Mth.lerp((double)partialTick, (double)player.yo, (double)player.getY()), Mth.lerp((double)partialTick, (double)player.zo, (double)player.getZ()));
            stack.mulPose(new Quaternionf().rotationY((-yaw + 180.0f) * ((float)Math.PI / 180)));
            stack.scale(-1.0f, -1.0f, 1.0f);
            renderer.scale(clientPlayer, stack, partialTick);
            stack.translate(0.0f, -1.5f, 0.0f);
            model.translateToHand(arm, stack);
            Vector4f vec = new Vector4f((float)offset.x(), (float)offset.y(), (float)offset.z(), 1.0f).mul((Matrix4fc)stack.last().pose());
            Vec3 pos = new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
            Vec3 subtract = pos.subtract(player.position());
            return Optional.of(player.position().add(subtract.scale((double)player.getScale())));
        }
        return Optional.empty();
    }

    public static Stream<String> getAllPartNames(ModelPart root) {
        return Stream.concat(root.children.keySet().stream(), root.children.values().stream().flatMap(ESModelUtil::getAllPartNames));
    }

    public static Map<String, ModelPartPose> saveModelSnapshot(List<String> allPartNames, Function<String, Optional<ModelPart>> getter) {
        HashMap<String, ModelPartPose> snapshot = new HashMap<String, ModelPartPose>();
        for (String name : allPartNames) {
            getter.apply(name).ifPresent(part -> snapshot.put(name, new ModelPartPose(part.x, part.y, part.z, part.xRot, part.yRot, part.zRot, part.xScale, part.yScale, part.zScale, part.visible)));
        }
        return snapshot;
    }

    public static void loadPoseFromSnapshot(Map<String, ModelPartPose> snapshot, Function<String, Optional<ModelPart>> getter) {
        snapshot.forEach((name, pose) -> ((Optional)getter.apply((String)name)).ifPresent(part -> {
            part.x = pose.x();
            part.y = pose.y();
            part.z = pose.z();
            part.xRot = pose.xRot();
            part.yRot = pose.yRot();
            part.zRot = pose.zRot();
            part.xScale = pose.xScale();
            part.yScale = pose.yScale();
            part.zScale = pose.zScale();
            part.visible = pose.visible();
        }));
    }
}

