/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.helper;

import cn.leolezury.eternalstarlight.common.client.ClientWeatherState;
import cn.leolezury.eternalstarlight.common.client.book.BookDefinition;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentRegistry;
import cn.leolezury.eternalstarlight.common.client.book.component.ConfiguredBookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.IndexBookComponent;
import cn.leolezury.eternalstarlight.common.client.gui.screen.BookScreen;
import cn.leolezury.eternalstarlight.common.client.gui.screen.CrestSelectionScreen;
import cn.leolezury.eternalstarlight.common.client.gui.screen.GatekeeperDialogueScreen;
import cn.leolezury.eternalstarlight.common.client.gui.toast.SimpleTextToast;
import cn.leolezury.eternalstarlight.common.client.handler.ESClientHandler;
import cn.leolezury.eternalstarlight.common.client.helper.ClientHelper;
import cn.leolezury.eternalstarlight.common.client.particle.advanced.AdvancedParticleOptions;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.projectile.SoulitSpectator;
import cn.leolezury.eternalstarlight.common.item.component.GuideBook;
import cn.leolezury.eternalstarlight.common.network.ClientDismountPacket;
import cn.leolezury.eternalstarlight.common.network.ClientMountPacket;
import cn.leolezury.eternalstarlight.common.network.OpenBookPacket;
import cn.leolezury.eternalstarlight.common.network.OpenCrestGuiPacket;
import cn.leolezury.eternalstarlight.common.network.OpenGatekeeperGuiPacket;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.network.SimpleActionPacket;
import cn.leolezury.eternalstarlight.common.network.UpdateBookPacket;
import cn.leolezury.eternalstarlight.common.network.UpdateCameraPacket;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.Color;
import cn.leolezury.eternalstarlight.common.util.Easing;
import cn.leolezury.eternalstarlight.common.util.SmoothSegmentedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSideHelper
implements ClientHelper {
    @Override
    public void handleServerToClientSimpleAction(SimpleActionPacket packet) {
        switch (packet.id()) {
            case "cancel_weather": {
                ClientWeatherState.weather = null;
            }
        }
    }

    @Override
    public void handleParticlePacket(ParticlePacket packet) {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel != null) {
            clientLevel.addParticle(packet.particle(), true, packet.x(), packet.y(), packet.z(), packet.dx(), packet.dy(), packet.dz());
        }
    }

    @Override
    public void handleOpenCrestGui(OpenCrestGuiPacket packet) {
        if (packet.ownedCrests().isEmpty()) {
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"message.eternal_starlight.no_crest"), true);
            }
        } else {
            Minecraft.getInstance().setScreen((Screen)new CrestSelectionScreen(packet.crests(), packet.ownedCrests()));
        }
    }

    @Override
    public void handleUpdateCamera(UpdateCameraPacket packet) {
        Entity camera;
        if (packet.cameraId() == -1) {
            ESClientHandler.resetCameraIn = 0;
        } else if (Minecraft.getInstance().level != null && !(Minecraft.getInstance().getCameraEntity() instanceof SoulitSpectator) && (camera = Minecraft.getInstance().level.getEntity(packet.cameraId())) != null) {
            ESClientHandler.resetCameraIn = 260;
            Minecraft.getInstance().options.hideGui = true;
            Minecraft.getInstance().setCameraEntity(camera);
        }
    }

    @Override
    public void handleClientMount(ClientMountPacket packet) {
        if (Minecraft.getInstance().level != null) {
            Entity rider = Minecraft.getInstance().level.getEntity(packet.riderId());
            Entity vehicle = Minecraft.getInstance().level.getEntity(packet.vehicleId());
            if (rider != null && vehicle != null) {
                rider.startRiding(vehicle, true);
            }
        }
    }

    @Override
    public void handleClientDismount(ClientDismountPacket packet) {
        Entity rider;
        if (Minecraft.getInstance().level != null && (rider = Minecraft.getInstance().level.getEntity(packet.riderId())) != null) {
            rider.stopRiding();
        }
    }

    @Override
    public void handleOpenGatekeeperGui(OpenGatekeeperGuiPacket packet) {
        Entity entity;
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel != null && (entity = clientLevel.getEntity(packet.id())) instanceof TheGatekeeper) {
            TheGatekeeper gatekeeper = (TheGatekeeper)entity;
            Minecraft.getInstance().setScreen((Screen)new GatekeeperDialogueScreen(gatekeeper, packet.challenged()));
        }
    }

    @Override
    public void handleUpdateBook(UpdateBookPacket packet) {
        HashSet<ResourceLocation> bookIds = new HashSet<ResourceLocation>();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Inventory inventory = player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                GuideBook guideBook = (GuideBook)stack.get(ESDataComponents.BOOK.get());
                if (guideBook == null) continue;
                bookIds.add(guideBook.id());
            }
        }
        Set definitions = bookIds.stream().map(ESClientHandler.books::getBook).collect(Collectors.toSet());
        ArrayList<IndexBookComponent.Entry> newEntries = new ArrayList<IndexBookComponent.Entry>();
        ArrayList<IndexBookComponent.Entry> changedEntries = new ArrayList<IndexBookComponent.Entry>();
        for (BookDefinition definition : definitions) {
            ArrayList entries = new ArrayList();
            definition.components().stream().flatMap(Collection::stream).filter(c -> c.component() == BookComponentRegistry.INDEX).forEach(c -> {
                Object patt0$temp = c.config();
                if (patt0$temp instanceof IndexBookComponent.Config) {
                    IndexBookComponent.Config config = (IndexBookComponent.Config)patt0$temp;
                    entries.addAll(config.entries());
                }
            });
            block2: for (IndexBookComponent.Entry entry : entries) {
                boolean enabled;
                Optional<ConfiguredBookComponent<?, ?>> jumpTo = definition.getComponent(entry.getJumpToId());
                boolean oldEnabled = jumpTo.isPresent() && jumpTo.get().isEnabled(packet.oldUnlocked());
                boolean bl = enabled = jumpTo.isPresent() && jumpTo.get().isEnabled(packet.unlocked());
                if (!oldEnabled && enabled) {
                    newEntries.add(entry);
                }
                for (ResourceLocation listeningId : entry.getListeningIds()) {
                    boolean listeningEnabled;
                    Optional<ConfiguredBookComponent<?, ?>> listening = definition.getComponent(listeningId);
                    boolean oldListeningEnabled = listening.isPresent() && listening.get().isEnabled(packet.oldUnlocked());
                    boolean bl2 = listeningEnabled = listening.isPresent() && listening.get().isEnabled(packet.unlocked());
                    if (oldListeningEnabled || !listeningEnabled) continue;
                    changedEntries.add(entry);
                    continue block2;
                }
            }
        }
        changedEntries.removeAll(newEntries);
        if (newEntries.size() > 3) {
            Minecraft.getInstance().getToasts().addToast((Toast)new SimpleTextToast((Component)Component.translatable((String)"book.eternal_starlight.unlock"), (Component)Component.translatable((String)"book.eternal_starlight.unlock.multiple"), ESItems.BOOK.get().getDefaultInstance()));
        } else {
            for (IndexBookComponent.Entry entry : newEntries) {
                Minecraft.getInstance().getToasts().addToast((Toast)new SimpleTextToast((Component)Component.translatable((String)"book.eternal_starlight.unlock"), entry.getText(), entry.getIcon()));
            }
        }
        if (changedEntries.size() > 3) {
            Minecraft.getInstance().getToasts().addToast((Toast)new SimpleTextToast((Component)Component.translatable((String)"book.eternal_starlight.update"), (Component)Component.translatable((String)"book.eternal_starlight.unlock.multiple"), ESItems.BOOK.get().getDefaultInstance()));
        } else {
            for (IndexBookComponent.Entry entry : changedEntries) {
                Minecraft.getInstance().getToasts().addToast((Toast)new SimpleTextToast((Component)Component.translatable((String)"book.eternal_starlight.update"), entry.getText(), entry.getIcon()));
            }
        }
    }

    @Override
    public void handleOpenBook(OpenBookPacket packet) {
        BookDefinition definition = ESClientHandler.books.getBook(packet.bookId());
        if (definition != null) {
            Minecraft.getInstance().setScreen((Screen)new BookScreen(definition, packet.unlocked()));
        }
    }

    @Override
    public void spawnStellarRackParticles(Vec3 center) {
        int i;
        if ((double)AdvancedParticleOptions.RANDOM.nextFloat() < 0.3) {
            if (AdvancedParticleOptions.RANDOM.nextBoolean()) {
                float size = (float)(1.0 + ((double)AdvancedParticleOptions.RANDOM.nextFloat() - 0.5) * 0.4);
                new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_BACK, 0.1f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, (float)((12.0 + ((double)AdvancedParticleOptions.RANDOM.nextFloat() - 0.5) * 10.0) * 0.01745329238474369), (float)((18.0 + ((double)AdvancedParticleOptions.RANDOM.nextFloat() - 0.5) * 10.0) * 0.01745329238474369), 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, size, 0.4f).add(Easing.IN_OUT_BOUNCE, size, 0.0f, 0.6f)).lifetime((int)(40.0 + ((double)AdvancedParticleOptions.RANDOM.nextFloat() - 0.5) * 20.0)).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.11764707f, 0.17764707f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.2682353f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.29882354f, 0.29411766f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)((ParticleType)ESParticles.SHINE.get())), (float)center.x, (float)center.y, (float)center.z);
            }
            for (i = 0; i < 4; ++i) {
                new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_BACK, 0.1f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.2f, 0.6f).add(Easing.IN_OUT_BOUNCE, 0.2f, 0.0f, 0.4f)).lifetime((int)(40.0 + ((double)AdvancedParticleOptions.RANDOM.nextFloat() - 0.5) * 20.0)).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)((ParticleType)ESParticles.ADVANCED_GLOW.get())), (float)center.x, (float)center.y, (float)center.z);
            }
        }
        for (i = 0; i < 5; ++i) {
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.15f, 0.5f).add(Easing.IN_OUT_BOUNCE, 0.15f, 0.0f, 0.5f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)((ParticleType)ESParticles.ADVANCED_GLOW.get())), (float)center.x, (float)center.y + 0.45f, (float)center.z);
        }
    }

    @Override
    public void spawnStellarRackItemParticles(Vec3 center) {
        for (int i = 0; i < 5; ++i) {
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.15f, 0.5f).add(Easing.IN_OUT_BOUNCE, 0.15f, 0.0f, 0.5f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)((ParticleType)ESParticles.ADVANCED_GLOW.get())), (float)center.x, (float)center.y, (float)center.z);
        }
    }

    @Override
    public void spawnManaCrystalItemParticles(ManaType type, Vec3 center) {
        for (int i = 0; i < 5; ++i) {
            Vec3 pos = center.offsetRandom(AdvancedParticleOptions.RANDOM, 0.5f);
            Color color = Color.rgb(type.getColor());
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, AdvancedParticleOptions.RANDOM.nextFloat() * 0.015f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.25f, 0.6f).add(Easing.IN_OUT_BOUNCE, 0.25f, 0.0f, 0.4f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, (float)color.r() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (float)color.g() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (float)color.b() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)((ParticleType)ESParticles.ADVANCED_GLOW.get())), (float)pos.x, (float)pos.y, (float)pos.z);
        }
    }
}

