/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.block.AlloyFurnaceBlock;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.item.menu.AlloyFurnaceMenu;
import cn.leolezury.eternalstarlight.common.item.recipe.AlloyRecipe;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESRecipes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class AlloyFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final String TAG_LIT_TICKS = "lit_ticks";
    private static final String TAG_TOTAL_LIT_TICKS = "total_lit_ticks";
    private static final String TAG_BURN_TICKS = "burn_ticks";
    private static final String TAG_TOTAL_BURN_TICKS = "total_burn_ticks";
    private static final String TAG_OVERHEAT_TICKS = "overheat_ticks";
    private static final String TAG_COOLING_TICKS = "cooling_ticks";
    private static final String TAG_TOTAL_COOLING_TICKS = "total_cooling_ticks";
    private static final String TAG_COOLING_EFFICIENCY = "cooling_efficiency";
    private static final int[] SLOTS_FOR_DOWN = new int[]{11, 12, 13};
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] SLOTS_FOR_FRONT_AND_BACK = new int[]{9};
    private static final int[] SLOTS_FOR_SIDES = new int[]{10};
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int id) {
            return switch (id) {
                case 0 -> {
                    if (AlloyFurnaceBlockEntity.this.totalLitTicks > Short.MAX_VALUE) {
                        yield Mth.floor((double)((double)AlloyFurnaceBlockEntity.this.litTicks / (double)AlloyFurnaceBlockEntity.this.totalLitTicks * 32767.0));
                    }
                    yield AlloyFurnaceBlockEntity.this.litTicks;
                }
                case 1 -> Math.min(AlloyFurnaceBlockEntity.this.totalLitTicks, Short.MAX_VALUE);
                case 2 -> AlloyFurnaceBlockEntity.this.burnTicks;
                case 3 -> AlloyFurnaceBlockEntity.this.totalBurnTicks;
                case 4 -> AlloyFurnaceBlockEntity.this.overheatTicks;
                case 5 -> AlloyFurnaceBlockEntity.this.coolingTicks;
                case 6 -> AlloyFurnaceBlockEntity.this.totalCoolingTicks;
                default -> 0;
            };
        }

        public void set(int id, int value) {
            switch (id) {
                case 0: {
                    AlloyFurnaceBlockEntity.this.litTicks = value;
                    break;
                }
                case 1: {
                    AlloyFurnaceBlockEntity.this.totalLitTicks = value;
                    break;
                }
                case 2: {
                    AlloyFurnaceBlockEntity.this.burnTicks = value;
                    break;
                }
                case 3: {
                    AlloyFurnaceBlockEntity.this.totalBurnTicks = value;
                }
                case 4: {
                    AlloyFurnaceBlockEntity.this.overheatTicks = value;
                }
                case 5: {
                    AlloyFurnaceBlockEntity.this.coolingTicks = value;
                }
                case 6: {
                    AlloyFurnaceBlockEntity.this.totalCoolingTicks = value;
                }
            }
        }

        public int getCount() {
            return 7;
        }
    };
    private final RecipeManager.CachedCheck<CraftingInput, AlloyRecipe> quickCheck;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)14, (Object)ItemStack.EMPTY);
    private int litTicks;
    private int totalLitTicks;
    private int burnTicks;
    private int totalBurnTicks;
    private int overheatTicks;
    private int coolingTicks;
    private int totalCoolingTicks;
    private int coolingEfficiency;
    private int checkStructureTicks;
    public float oldClientOverheatAmplitude;
    public float clientOverheatAmplitude;
    public int oldClientAnimationTicks;
    public int clientAnimationTicks;

    public AlloyFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(ESBlockEntities.ALLOY_FURNACE.get(), pos, state);
        this.quickCheck = RecipeManager.createCheck(ESRecipes.ALLOY.get());
    }

    public static int getTotalOverheatTicks() {
        return ESConfig.INSTANCE.itemsConfig.alloyFurnace.totalOverheatTicks();
    }

    public static int getOverheatAnimationThreshold() {
        return AlloyFurnaceBlockEntity.getTotalOverheatTicks() * 5 / 6;
    }

    public boolean isLit() {
        return this.litTicks > 0;
    }

    public boolean isCooling() {
        return this.coolingTicks > 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AlloyFurnaceBlockEntity entity) {
        if (!level.isClientSide) {
            Block block;
            ItemStack coolingItem;
            ItemStack fuel;
            boolean oldLit = entity.litTicks > 0;
            boolean oldCooling = entity.coolingTicks > 0;
            boolean oldShowOverheatAnimation = entity.overheatTicks >= AlloyFurnaceBlockEntity.getOverheatAnimationThreshold();
            boolean changed = false;
            if (entity.litTicks > 0) {
                --entity.litTicks;
            }
            if (entity.coolingTicks > 0) {
                --entity.coolingTicks;
            }
            if (entity.litTicks <= 0) {
                entity.totalLitTicks = 0;
            }
            if (entity.coolingTicks <= 0) {
                entity.totalCoolingTicks = 0;
                entity.coolingEfficiency = 0;
            }
            List<ItemStack> ingredients = entity.getIngredientItems();
            RecipeHolder recipeHolder = entity.quickCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)3, (int)3, ingredients), level).orElse(null);
            if (entity.canBurn() && entity.litTicks <= 0 && !(fuel = entity.getItem(9)).isEmpty() && AlloyFurnaceBlockEntity.isFuel(fuel)) {
                entity.litTicks = entity.totalLitTicks = ESPlatform.INSTANCE.getBurnTime(fuel, ESRecipes.ALLOY.get());
                fuel.shrink(1);
                if (ESPlatform.INSTANCE.hasCraftingRemainingItem(fuel)) {
                    ESPlatform.INSTANCE.getCraftingRemainingItem(fuel).ifPresent(remaining -> {
                        if (fuel.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)fuel, (ItemStack)remaining)) {
                            int remainingCount = fuel.getCount() + remaining.getCount() - remaining.getMaxStackSize();
                            entity.setItem(9, remaining.copyWithCount(Math.min(fuel.getCount() + remaining.getCount(), remaining.getMaxStackSize())));
                            if (remainingCount > 0) {
                                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)remaining.copyWithCount(remainingCount));
                            }
                        } else {
                            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)remaining.copy());
                        }
                    });
                }
                changed = true;
            }
            if (entity.overheatTicks > 0 && entity.coolingTicks <= 0 && !(coolingItem = entity.getItem(10)).isEmpty() && AlloyFurnaceBlockEntity.isCoolingItem(coolingItem)) {
                entity.coolingTicks = entity.totalCoolingTicks = AlloyFurnaceBlock.getCoolDuration(coolingItem.getItem());
                entity.coolingEfficiency = AlloyFurnaceBlock.getCoolEfficiency(coolingItem.getItem());
                coolingItem.shrink(1);
                if (ESPlatform.INSTANCE.hasCraftingRemainingItem(coolingItem)) {
                    ESPlatform.INSTANCE.getCraftingRemainingItem(coolingItem).ifPresent(remaining -> {
                        if (coolingItem.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)coolingItem, (ItemStack)remaining)) {
                            int remainingCount = coolingItem.getCount() + remaining.getCount() - remaining.getMaxStackSize();
                            entity.setItem(10, remaining.copyWithCount(Math.min(coolingItem.getCount() + remaining.getCount(), remaining.getMaxStackSize())));
                            if (remainingCount > 0) {
                                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)remaining.copyWithCount(remainingCount));
                            }
                        } else {
                            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)remaining.copy());
                        }
                    });
                }
                changed = true;
            }
            entity.burnTicks = entity.burnTicks + (entity.litTicks > 0 && entity.canBurn() ? 1 : -1);
            entity.burnTicks = Mth.clamp((int)entity.burnTicks, (int)0, (int)entity.totalBurnTicks);
            if (entity.litTicks > 0 && (entity.coolingTicks <= 0 || entity.litTicks % entity.coolingEfficiency == 0)) {
                ++entity.overheatTicks;
            }
            if (entity.litTicks <= 0) {
                entity.overheatTicks = entity.overheatTicks - (1 + (entity.coolingTicks > 0 ? entity.coolingEfficiency : 0));
            }
            entity.overheatTicks = Mth.clamp((int)entity.overheatTicks, (int)0, (int)AlloyFurnaceBlockEntity.getTotalOverheatTicks());
            if (entity.canBurn() && entity.burnTicks == entity.totalBurnTicks && recipeHolder != null) {
                AlloyRecipe.Result result;
                ItemStack stack;
                AlloyRecipe recipe = (AlloyRecipe)recipeHolder.value();
                for (int i = 0; i < Math.min(recipe.results().size(), 3) && !(stack = (result = (AlloyRecipe.Result)recipe.results().get(i)).getResultItem(level.getRandom())).isEmpty(); ++i) {
                    ItemStack existingResult = entity.getItem(11 + i);
                    entity.setItem(11 + i, stack.copyWithCount(stack.getCount() + existingResult.getCount()));
                }
                NonNullList remaining2 = ((AlloyRecipe)recipeHolder.value()).getRemainingItems((RecipeInput)CraftingInput.of((int)3, (int)3, ingredients));
                for (int y = 0; y < 3; ++y) {
                    int index;
                    for (int x = 0; x < 3 && (index = x + y * 3) < remaining2.size(); ++x) {
                        ItemStack craftItem = entity.getItem(0 + index);
                        ItemStack remainingItem = (ItemStack)remaining2.get(index);
                        if (!craftItem.isEmpty()) {
                            craftItem.shrink(1);
                            entity.setItem(0 + index, craftItem);
                        }
                        if (remainingItem.isEmpty()) continue;
                        if (craftItem.isEmpty()) {
                            entity.setItem(0 + index, remainingItem);
                            continue;
                        }
                        if (ItemStack.isSameItemSameComponents((ItemStack)craftItem, (ItemStack)remainingItem)) {
                            remainingItem.grow(craftItem.getCount());
                            entity.setItem(0 + index, remainingItem);
                            continue;
                        }
                        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)remainingItem.copy());
                    }
                }
                entity.burnTicks = 0;
                changed = true;
            }
            if (entity.litTicks > 0 != oldLit || entity.coolingTicks > 0 != oldCooling || entity.overheatTicks >= AlloyFurnaceBlockEntity.getOverheatAnimationThreshold() != oldShowOverheatAnimation) {
                level.sendBlockUpdated(pos, state, state, 3);
                changed = true;
            }
            if (changed) {
                entity.setChanged();
            }
            ++entity.checkStructureTicks;
            if (entity.checkStructureTicks > 20 && (block = state.getBlock()) instanceof AlloyFurnaceBlock) {
                AlloyFurnaceBlock block2 = (AlloyFurnaceBlock)block;
                block2.checkStructure((LevelAccessor)level, pos);
                entity.checkStructureTicks = 0;
            }
            if (entity.overheatTicks >= AlloyFurnaceBlockEntity.getTotalOverheatTicks()) {
                level.destroyBlock(pos, false);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ESExplosionParticleOptions.LAVA, (double)((float)pos.getX() + level.getRandom().nextFloat()), (double)((float)pos.getY() + level.getRandom().nextFloat()) + 1.5, (double)((float)pos.getZ() + level.getRandom().nextFloat()), 20, 1.5, 1.5, 1.5, 0.0);
                    serverLevel.sendParticles((ParticleOptions)ESParticles.SMOKE_TRAIL.get(), (double)((float)pos.getX() + level.getRandom().nextFloat()), (double)((float)pos.getY() + level.getRandom().nextFloat()), (double)((float)pos.getZ() + level.getRandom().nextFloat()), 20, 0.0, 0.0, 0.0, 0.5);
                }
                level.explode(null, null, null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (float)ESConfig.INSTANCE.itemsConfig.alloyFurnace.explosionRadius(), true, Level.ExplosionInteraction.BLOCK, (ParticleOptions)ESExplosionParticleOptions.LAVA, (ParticleOptions)ESExplosionParticleOptions.LAVA, (Holder)SoundEvents.GENERIC_EXPLODE);
            }
        } else {
            entity.oldClientOverheatAmplitude = entity.clientOverheatAmplitude;
            entity.clientOverheatAmplitude = entity.clientOverheatAmplitude + (entity.overheatTicks >= AlloyFurnaceBlockEntity.getOverheatAnimationThreshold() ? 0.003f : -0.003f);
            entity.clientOverheatAmplitude = Mth.clamp((float)entity.clientOverheatAmplitude, (float)0.0f, (float)1.0f);
            entity.oldClientAnimationTicks = entity.clientAnimationTicks++;
            if (level.getRandom().nextDouble() < 0.1) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getX() + 0.5, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    private List<ItemStack> getIngredientItems() {
        return this.getItems().subList(0, 9);
    }

    private boolean canBurn() {
        if (this.level == null) {
            return false;
        }
        Optional recipeHolder = this.quickCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)3, (int)3, this.getIngredientItems()), this.level);
        if (this.getIngredientItems().stream().anyMatch(stack -> !stack.isEmpty()) && recipeHolder.isPresent()) {
            AlloyRecipe recipe = (AlloyRecipe)((RecipeHolder)recipeHolder.get()).value();
            for (int i = 0; i < Math.min(recipe.results().size(), 3); ++i) {
                AlloyRecipe.Result result = (AlloyRecipe.Result)recipe.results().get(i);
                ItemStack stack2 = result.getMaxResultItem();
                if (stack2.isEmpty()) {
                    return false;
                }
                ItemStack existingResult = this.getItem(11 + i);
                if (!existingResult.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)existingResult, (ItemStack)stack2)) {
                    return false;
                }
                if (existingResult.getCount() + stack2.getCount() <= stack2.getMaxStackSize()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isFuel(ItemStack stack) {
        return FurnaceBlockEntity.isFuel((ItemStack)stack);
    }

    public static boolean isCoolingItem(ItemStack stack) {
        return AlloyFurnaceBlock.getCoolingItem(stack.getItem()) != null;
    }

    public void setItem(int index, ItemStack stack) {
        boolean unchanged;
        ItemStack original = (ItemStack)this.items.get(index);
        boolean bl = unchanged = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)original, (ItemStack)stack);
        if (this.level != null && index >= 0 && index < 9 && !unchanged) {
            List ingredients = this.getItems().subList(0, 9);
            ingredients.set(index - 0, stack);
            this.quickCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)3, (int)3, (List)ingredients), this.level).ifPresentOrElse(holder -> {
                this.totalBurnTicks = ((AlloyRecipe)holder.value()).burnTime();
            }, () -> {
                this.totalBurnTicks = 0;
            });
            this.burnTicks = 0;
            this.setChanged();
        }
        super.setItem(index, stack);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index == 9 && !AlloyFurnaceBlockEntity.isFuel(stack)) {
            return false;
        }
        if (index == 10 && !AlloyFurnaceBlockEntity.isCoolingItem(stack)) {
            return false;
        }
        return super.canPlaceItem(index, stack);
    }

    public int getContainerSize() {
        return 14;
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        this.litTicks = compoundTag.getShort(TAG_LIT_TICKS);
        this.totalLitTicks = compoundTag.getShort(TAG_TOTAL_LIT_TICKS);
        this.burnTicks = compoundTag.getShort(TAG_BURN_TICKS);
        this.totalBurnTicks = compoundTag.getShort(TAG_TOTAL_BURN_TICKS);
        this.overheatTicks = compoundTag.getShort(TAG_OVERHEAT_TICKS);
        this.coolingTicks = compoundTag.getShort(TAG_COOLING_TICKS);
        this.totalCoolingTicks = compoundTag.getShort(TAG_TOTAL_COOLING_TICKS);
        this.coolingEfficiency = compoundTag.getShort(TAG_COOLING_EFFICIENCY);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        compoundTag.putShort(TAG_LIT_TICKS, (short)this.litTicks);
        compoundTag.putShort(TAG_TOTAL_LIT_TICKS, (short)this.totalLitTicks);
        compoundTag.putShort(TAG_BURN_TICKS, (short)this.burnTicks);
        compoundTag.putShort(TAG_TOTAL_BURN_TICKS, (short)this.totalBurnTicks);
        compoundTag.putShort(TAG_OVERHEAT_TICKS, (short)this.overheatTicks);
        compoundTag.putShort(TAG_COOLING_TICKS, (short)this.coolingTicks);
        compoundTag.putShort(TAG_TOTAL_COOLING_TICKS, (short)this.totalCoolingTicks);
        compoundTag.putShort(TAG_COOLING_EFFICIENCY, (short)this.coolingEfficiency);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomOnly(provider);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.eternal_starlight.alloy_furnace");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new AlloyFurnaceMenu(id, player.player.getInventory(), (Container)this, this.dataAccess);
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if (side == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        if (side.getAxis() == ((Direction)this.getBlockState().getValue((Property)AlloyFurnaceBlock.FACING)).getAxis()) {
            return SLOTS_FOR_FRONT_AND_BACK;
        }
        return SLOTS_FOR_SIDES;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        if (index == 9 || index == 10 || this.level == null) {
            return this.canPlaceItem(index, stack);
        }
        Optional recipeHolder = this.quickCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)3, (int)3, this.getIngredientItems()), this.level);
        if (recipeHolder.isPresent()) {
            return !this.getItem(index).isEmpty() && this.canPlaceItem(index, stack);
        }
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }
}

