/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.entity.SolarEggBlockEntity;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class SolarEggBlock
extends BaseEntityBlock {
    public static final MapCodec<SolarEggBlock> CODEC = SolarEggBlock.simpleCodec(SolarEggBlock::new);
    public static final IntegerProperty X_OFFSET = IntegerProperty.create((String)"x_offset", (int)0, (int)2);
    public static final IntegerProperty Y_OFFSET = IntegerProperty.create((String)"y_offset", (int)0, (int)2);
    public static final IntegerProperty Z_OFFSET = IntegerProperty.create((String)"z_offset", (int)0, (int)2);
    private static final Map<Triple<Integer, Integer, Integer>, VoxelShape> SHAPES = (Map)Util.make(() -> {
        HashMap<Triple, VoxelShape> map = new HashMap<Triple, VoxelShape>();
        for (int x = 0; x <= 2; ++x) {
            for (int z = 0; z <= 2; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    map.put(Triple.of((Object)x, (Object)y, (Object)z), Block.box((double)Math.max(0.0, 1.0 - (double)x), (double)0.0, (double)Math.max(0.0, 1.0 - (double)z), (double)Math.min(16.0, 17.0 - (double)x), (double)(y == 2 ? 14.0 : 16.0), (double)Math.min(16.0, 17.0 - (double)z)));
                }
            }
        }
        return map;
    });

    public SolarEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)X_OFFSET, (Comparable)Integer.valueOf(1))).setValue((Property)Y_OFFSET, (Comparable)Integer.valueOf(0))).setValue((Property)Z_OFFSET, (Comparable)Integer.valueOf(1)));
    }

    protected MapCodec<SolarEggBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        CollisionContext collisionContext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        VoxelShape shape = Shapes.empty();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    if (!level.getBlockState(pos.offset(x, y, z)).canBeReplaced(context) || !level.getWorldBorder().isWithinBounds(pos.offset(x, y, z))) {
                        return null;
                    }
                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)X_OFFSET, (Comparable)Integer.valueOf(x + 1))).setValue((Property)Y_OFFSET, (Comparable)Integer.valueOf(y))).setValue((Property)Z_OFFSET, (Comparable)Integer.valueOf(z + 1))).getCollisionShape((BlockGetter)level, pos, collisionContext).move((double)(pos.getX() + x), (double)(pos.getY() + y), (double)(pos.getZ() + z)));
                }
            }
        }
        if (!level.isUnobstructed(null, shape)) {
            return null;
        }
        return super.getStateForPlacement(context);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    level.setBlockAndUpdate(pos.offset(x, y, z), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)X_OFFSET, (Comparable)Integer.valueOf(x + 1))).setValue((Property)Y_OFFSET, (Comparable)Integer.valueOf(y))).setValue((Property)Z_OFFSET, (Comparable)Integer.valueOf(z + 1)));
                }
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!((Integer)state.getValue((Property)X_OFFSET) != 1 || (Integer)state.getValue((Property)Y_OFFSET) != 0 || (Integer)state.getValue((Property)Z_OFFSET) != 1 || newState.is((Block)this) && (Integer)newState.getValue((Property)X_OFFSET) == 1 && (Integer)newState.getValue((Property)Y_OFFSET) == 0 && (Integer)newState.getValue((Property)Z_OFFSET) == 1)) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = 0; y <= 2; ++y) {
                        if (!level.getBlockState(pos.offset(x, y, z)).is((Block)this) || x == 0 && y == 0 && z == 0) continue;
                        level.destroyBlock(pos.offset(x, y, z), false);
                    }
                }
            }
        } else {
            this.checkStructure((LevelAccessor)level, pos.offset(1 - (Integer)state.getValue((Property)X_OFFSET), -((Integer)state.getValue((Property)Y_OFFSET)).intValue(), 1 - (Integer)state.getValue((Property)Z_OFFSET)));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void checkStructure(LevelAccessor level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.is((Block)this) && (Integer)state.getValue((Property)X_OFFSET) == 1 && (Integer)state.getValue((Property)Y_OFFSET) == 0 && (Integer)state.getValue((Property)Z_OFFSET) == 1) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = 0; y <= 2; ++y) {
                        BlockState partState = level.getBlockState(pos.offset(x, y, z));
                        if (partState.is((Block)this) && (Integer)partState.getValue((Property)X_OFFSET) == x + 1 && (Integer)partState.getValue((Property)Y_OFFSET) == y && (Integer)partState.getValue((Property)Z_OFFSET) == z + 1) continue;
                        level.destroyBlock(pos, false);
                        return;
                    }
                }
            }
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.getOrDefault(Triple.of((Object)((Integer)state.getValue((Property)X_OFFSET)), (Object)((Integer)state.getValue((Property)Y_OFFSET)), (Object)((Integer)state.getValue((Property)Z_OFFSET))), Shapes.block());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{X_OFFSET, Z_OFFSET, Y_OFFSET});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return (Integer)state.getValue((Property)X_OFFSET) == 1 && (Integer)state.getValue((Property)Y_OFFSET) == 0 && (Integer)state.getValue((Property)Z_OFFSET) == 1 ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)X_OFFSET) == 1 && (Integer)state.getValue((Property)Y_OFFSET) == 0 && (Integer)state.getValue((Property)Z_OFFSET) == 1 ? new SolarEggBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return (Integer)blockState.getValue((Property)X_OFFSET) == 1 && (Integer)blockState.getValue((Property)Y_OFFSET) == 0 && (Integer)blockState.getValue((Property)Z_OFFSET) == 1 ? SolarEggBlock.createTickerHelper(blockEntityType, ESBlockEntities.SOLAR_EGG.get(), SolarEggBlockEntity::tick) : null;
    }
}

