/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PolishedToxiteBlock
extends Block {
    public static final MapCodec<PolishedToxiteBlock> CODEC = PolishedToxiteBlock.simpleCodec(PolishedToxiteBlock::new);
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);

    public PolishedToxiteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(PART, (Comparable)((Object)Part.FULL)));
    }

    protected MapCodec<PolishedToxiteBlock> codec() {
        return CODEC;
    }

    protected BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        boolean above = levelAccessor.getBlockState(blockPos.above()).is((Block)this);
        boolean below = levelAccessor.getBlockState(blockPos.below()).is((Block)this);
        if (!above && !below) {
            return (BlockState)blockState.setValue(PART, (Comparable)((Object)Part.FULL));
        }
        if (above && below) {
            return (BlockState)blockState.setValue(PART, (Comparable)((Object)Part.MIDDLE));
        }
        if (above) {
            return (BlockState)blockState.setValue(PART, (Comparable)((Object)Part.LOWER));
        }
        return (BlockState)blockState.setValue(PART, (Comparable)((Object)Part.UPPER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART});
    }

    public static enum Part implements StringRepresentable
    {
        FULL("full"),
        UPPER("upper"),
        MIDDLE("middle"),
        LOWER("lower");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

