/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.AlloyFurnaceCoolingItem;
import cn.leolezury.eternalstarlight.common.block.WeatheringGolemSteel;
import cn.leolezury.eternalstarlight.common.block.entity.AlloyFurnaceBlockEntity;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class AlloyFurnaceBlock
extends BaseEntityBlock
implements WorldlyContainerHolder,
WeatheringGolemSteel {
    public static final MapCodec<AlloyFurnaceBlock> CODEC = AlloyFurnaceBlock.simpleCodec(AlloyFurnaceBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty X_OFFSET = IntegerProperty.create((String)"x_offset", (int)0, (int)1);
    public static final IntegerProperty Y_OFFSET = IntegerProperty.create((String)"y_offset", (int)0, (int)2);
    public static final IntegerProperty Z_OFFSET = IntegerProperty.create((String)"z_offset", (int)0, (int)2);
    private static final Map<Pair<Direction, Triple<Integer, Integer, Integer>>, VoxelShape> SHAPES = (Map)Util.make(() -> {
        HashMap<Pair, VoxelShape> map = new HashMap<Pair, VoxelShape>();
        for (int x = 0; x <= 2; ++x) {
            for (int z = 0; z <= 2; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    VoxelShape shape = Shapes.block();
                    if (x == 0 && y == 0 && z == 2) {
                        shape = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0));
                    } else if (x == 1 && y == 0 && z == 2) {
                        shape = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0));
                    } else if (x == 0 && y == 1 && z == 2) {
                        shape = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)6.0), Block.box((double)7.0, (double)12.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0)});
                    } else if (x == 1 && y == 1 && z == 2) {
                        shape = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)10.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)7.0, (double)12.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0)});
                    } else if (x == 0 && y == 2 && z == 2) {
                        shape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)6.0, (double)3.0);
                    } else if (x == 1 && y == 2 && z == 2) {
                        shape = Block.box((double)0.0, (double)0.0, (double)13.0, (double)13.0, (double)6.0, (double)16.0);
                    } else if (x == 0 && y == 2 && z == 1) {
                        shape = Block.box((double)7.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)3.0);
                    } else if (x == 1 && y == 2 && z == 1) {
                        shape = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.0, (double)13.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)7.0, (double)5.0, (double)8.0, (double)15.0), Block.box((double)0.0, (double)8.0, (double)6.0, (double)6.0, (double)12.0, (double)16.0)});
                    } else if (x == 0 && y == 2) {
                        shape = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)12.0, (double)9.0), (VoxelShape)Block.box((double)2.0, (double)12.0, (double)0.0, (double)14.0, (double)16.0, (double)10.0));
                    } else if (x == 1 && y == 2) {
                        shape = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.box((double)13.0, (double)0.0, (double)7.0, (double)16.0, (double)8.0, (double)15.0), Block.box((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)12.0, (double)16.0)});
                    }
                    for (Direction direction : Direction.values()) {
                        if (direction.getAxis() == Direction.Axis.Y) continue;
                        map.put(Pair.of((Object)direction, (Object)Triple.of((Object)x, (Object)y, (Object)z)), ESBlockUtil.rotateVoxelShape(shape, -90, 180, direction));
                    }
                }
            }
        }
        return map;
    });
    private static final Map<Item, AlloyFurnaceCoolingItem> COOLING_REGISTRY = new HashMap<Item, AlloyFurnaceCoolingItem>();

    public AlloyFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)X_OFFSET, (Comparable)Integer.valueOf(0))).setValue((Property)Y_OFFSET, (Comparable)Integer.valueOf(0))).setValue((Property)Z_OFFSET, (Comparable)Integer.valueOf(1)));
    }

    protected MapCodec<AlloyFurnaceBlock> codec() {
        return CODEC;
    }

    public static void registerCoolingItem(Item item, AlloyFurnaceCoolingItem coolingItem) {
        COOLING_REGISTRY.put(item, coolingItem);
    }

    public static void registerCoolingItem(TagKey<Item> itemTag, AlloyFurnaceCoolingItem coolingItem) {
        for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(itemTag)) {
            COOLING_REGISTRY.put((Item)holder.value(), coolingItem);
        }
    }

    public static AlloyFurnaceCoolingItem getCoolingItem(Item item) {
        return COOLING_REGISTRY.get(item);
    }

    public static int getCoolDuration(Item item) {
        AlloyFurnaceCoolingItem coolingItem = AlloyFurnaceBlock.getCoolingItem(item);
        return coolingItem == null ? 0 : coolingItem.duration();
    }

    public static int getCoolEfficiency(Item item) {
        AlloyFurnaceCoolingItem coolingItem = AlloyFurnaceBlock.getCoolingItem(item);
        return coolingItem == null ? 0 : coolingItem.efficiency();
    }

    public static Map<Item, AlloyFurnaceCoolingItem> getCoolingRegistry() {
        return Collections.unmodifiableMap(COOLING_REGISTRY);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        CollisionContext collisionContext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        Direction facing = context.getHorizontalDirection().getOpposite();
        VoxelShape shape = Shapes.empty();
        for (int x = 0; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    int rotatedZ;
                    Vec3 rotated = new Vec3((double)x, 0.0, (double)z).yRot((-facing.toYRot() + 90.0f) * ((float)Math.PI / 180));
                    int rotatedX = Math.round((float)rotated.x);
                    if (!level.getBlockState(pos.offset(rotatedX, y, rotatedZ = Math.round((float)rotated.z))).canBeReplaced(context) || !level.getWorldBorder().isWithinBounds(pos.offset(rotatedX, y, rotatedZ))) {
                        return null;
                    }
                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)X_OFFSET, (Comparable)Integer.valueOf(x))).setValue((Property)Y_OFFSET, (Comparable)Integer.valueOf(y))).setValue((Property)Z_OFFSET, (Comparable)Integer.valueOf(z + 1))).getCollisionShape((BlockGetter)level, pos, collisionContext).move((double)(pos.getX() + rotatedX), (double)(pos.getY() + y), (double)(pos.getZ() + rotatedZ)));
                }
            }
        }
        if (!level.isUnobstructed(null, shape)) {
            return null;
        }
        BlockState state = super.getStateForPlacement(context);
        return state != null ? (BlockState)state.setValue((Property)FACING, (Comparable)facing) : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        Direction facing = (Direction)state.getValue((Property)FACING);
        for (int x = 0; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Vec3 rotated = new Vec3((double)x, 0.0, (double)z).yRot((-facing.toYRot() + 90.0f) * ((float)Math.PI / 180));
                    int rotatedX = Math.round((float)rotated.x);
                    int rotatedZ = Math.round((float)rotated.z);
                    level.setBlockAndUpdate(pos.offset(rotatedX, y, rotatedZ), (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)X_OFFSET, (Comparable)Integer.valueOf(x))).setValue((Property)Y_OFFSET, (Comparable)Integer.valueOf(y))).setValue((Property)Z_OFFSET, (Comparable)Integer.valueOf(z + 1)));
                }
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.use(stack, state, level, pos, player);
    }

    @Override
    public void spawnWaxOrScrapeParticles(Level level, BlockPos pos, ParticleOptions particle) {
        BlockState state = level.getBlockState(pos);
        Direction facing = (Direction)state.getValue((Property)FACING);
        Vec3 centerRotated = new Vec3((double)((Integer)state.getValue((Property)X_OFFSET)).intValue(), 0.0, (double)((Integer)state.getValue((Property)Z_OFFSET) - 1)).yRot((-facing.toYRot() + 90.0f) * ((float)Math.PI / 180));
        BlockPos centerPos = pos.offset(-Math.round((float)centerRotated.x), -((Integer)state.getValue((Property)Y_OFFSET)).intValue(), -Math.round((float)centerRotated.z));
        for (int x = 0; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 1; ++y) {
                    Vec3 rotated = new Vec3((double)x, 0.0, (double)z).yRot((-facing.toYRot() + 90.0f) * ((float)Math.PI / 180));
                    int rotatedX = Math.round((float)rotated.x);
                    int rotatedZ = Math.round((float)rotated.z);
                    BlockPos partPos = centerPos.offset(rotatedX, y, rotatedZ);
                    if (z == 1) {
                        ParticleUtils.spawnParticleInBlock((LevelAccessor)level, (BlockPos)partPos, (int)3, (ParticleOptions)particle);
                        continue;
                    }
                    ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)partPos, (ParticleOptions)particle, (IntProvider)UniformInt.of((int)3, (int)5));
                }
            }
        }
    }

    @Override
    public void placeTransformedBlock(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Vec3 centerRotated = new Vec3((double)((Integer)state.getValue((Property)X_OFFSET)).intValue(), 0.0, (double)((Integer)state.getValue((Property)Z_OFFSET) - 1)).yRot((-facing.toYRot() + 90.0f) * ((float)Math.PI / 180));
        BlockPos centerPos = pos.offset(-Math.round((float)centerRotated.x), -((Integer)state.getValue((Property)Y_OFFSET)).intValue(), -Math.round((float)centerRotated.z));
        level.setBlockAndUpdate(centerPos, (BlockState)((BlockState)((BlockState)state.setValue((Property)X_OFFSET, (Comparable)Integer.valueOf(0))).setValue((Property)Y_OFFSET, (Comparable)Integer.valueOf(0))).setValue((Property)Z_OFFSET, (Comparable)Integer.valueOf(1)));
        for (int x = 0; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    int rotatedZ;
                    if (x == 0 && y == 0 && z == 0) continue;
                    Vec3 rotated = new Vec3((double)x, 0.0, (double)z).yRot((-facing.toYRot() + 90.0f) * ((float)Math.PI / 180));
                    int rotatedX = Math.round((float)rotated.x);
                    BlockPos partPos = centerPos.offset(rotatedX, y, rotatedZ = Math.round((float)rotated.z));
                    if (!level.getBlockState(partPos).canBeReplaced() || !level.getWorldBorder().isWithinBounds(partPos)) continue;
                    level.setBlockAndUpdate(partPos, (BlockState)((BlockState)((BlockState)state.setValue((Property)X_OFFSET, (Comparable)Integer.valueOf(x))).setValue((Property)Y_OFFSET, (Comparable)Integer.valueOf(y))).setValue((Property)Z_OFFSET, (Comparable)Integer.valueOf(z + 1)));
                }
            }
        }
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        this.changeOverTime(blockState, serverLevel, blockPos, randomSource);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return !this.isOxidized() && !this.isWaxed();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        int x = (Integer)state.getValue((Property)X_OFFSET);
        int z = (Integer)state.getValue((Property)Z_OFFSET) - 1;
        Vec3 rotated = new Vec3((double)x, 0.0, (double)z).yRot((-facing.toYRot() + 90.0f) * ((float)Math.PI / 180));
        int rotatedX = Math.round((float)rotated.x);
        int rotatedZ = Math.round((float)rotated.z);
        BlockPos centerPos = pos.offset(-rotatedX, -((Integer)state.getValue((Property)Y_OFFSET)).intValue(), -rotatedZ);
        BlockEntity blockEntity = level.getBlockEntity(centerPos);
        if (blockEntity instanceof AlloyFurnaceBlockEntity) {
            AlloyFurnaceBlockEntity entity = (AlloyFurnaceBlockEntity)blockEntity;
            player.openMenu((MenuProvider)entity);
        }
        return InteractionResult.CONSUME;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AlloyFurnaceBlockEntity) {
                AlloyFurnaceBlockEntity entity = (AlloyFurnaceBlockEntity)blockEntity;
                if (!entity.isValidBlockState(newState)) {
                    if (level instanceof ServerLevel) {
                        Containers.dropContents((Level)level, (BlockPos)pos, (Container)entity);
                    }
                    super.onRemove(state, level, pos, newState, isMoving);
                }
            } else {
                super.onRemove(state, level, pos, newState, isMoving);
            }
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (!((Integer)state.getValue((Property)X_OFFSET) != 0 || (Integer)state.getValue((Property)Y_OFFSET) != 0 || (Integer)state.getValue((Property)Z_OFFSET) != 1 || newState.is((Block)this) && newState.getValue((Property)FACING) == facing && (Integer)newState.getValue((Property)X_OFFSET) == 0 && (Integer)newState.getValue((Property)Y_OFFSET) == 0 && (Integer)newState.getValue((Property)Z_OFFSET) == 1)) {
            for (int x = 0; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = 0; y <= 2; ++y) {
                        int rotatedZ;
                        Vec3 rotated = new Vec3((double)x, 0.0, (double)z).yRot((-facing.toYRot() + 90.0f) * ((float)Math.PI / 180));
                        int rotatedX = Math.round((float)rotated.x);
                        if (!level.getBlockState(pos.offset(rotatedX, y, rotatedZ = Math.round((float)rotated.z))).is((Block)this) || x == 0 && y == 0 && z == 0) continue;
                        level.destroyBlock(pos.offset(rotatedX, y, rotatedZ), false);
                    }
                }
            }
        } else {
            int x = (Integer)state.getValue((Property)X_OFFSET);
            int z = (Integer)state.getValue((Property)Z_OFFSET) - 1;
            Vec3 rotated = new Vec3((double)x, 0.0, (double)z).yRot((-facing.toYRot() + 90.0f) * ((float)Math.PI / 180));
            int rotatedX = Math.round((float)rotated.x);
            int rotatedZ = Math.round((float)rotated.z);
            this.checkStructure((LevelAccessor)level, pos.offset(-rotatedX, -((Integer)state.getValue((Property)Y_OFFSET)).intValue(), -rotatedZ));
        }
    }

    public void checkStructure(LevelAccessor level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.is((Block)this) && (Integer)state.getValue((Property)X_OFFSET) == 0 && (Integer)state.getValue((Property)Y_OFFSET) == 0 && (Integer)state.getValue((Property)Z_OFFSET) == 1) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            for (int x = 0; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = 0; y <= 2; ++y) {
                        int rotatedZ;
                        Vec3 rotated = new Vec3((double)x, 0.0, (double)z).yRot((-facing.toYRot() + 90.0f) * ((float)Math.PI / 180));
                        int rotatedX = Math.round((float)rotated.x);
                        BlockState partState = level.getBlockState(pos.offset(rotatedX, y, rotatedZ = Math.round((float)rotated.z)));
                        if (partState.is((Block)this) && partState.getValue((Property)FACING) == facing && (Integer)partState.getValue((Property)X_OFFSET) == x && (Integer)partState.getValue((Property)Y_OFFSET) == y && (Integer)partState.getValue((Property)Z_OFFSET) == z + 1) continue;
                        level.destroyBlock(pos, false);
                        return;
                    }
                }
            }
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.getOrDefault(Pair.of((Object)((Direction)state.getValue((Property)FACING)), (Object)Triple.of((Object)((Integer)state.getValue((Property)X_OFFSET)), (Object)((Integer)state.getValue((Property)Y_OFFSET)), (Object)((Integer)state.getValue((Property)Z_OFFSET)))), Shapes.block());
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, X_OFFSET, Z_OFFSET, Y_OFFSET});
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return (Integer)blockState.getValue((Property)X_OFFSET) == 0 && (Integer)blockState.getValue((Property)Y_OFFSET) == 0 && (Integer)blockState.getValue((Property)Z_OFFSET) == 1 ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)X_OFFSET) == 0 && (Integer)blockState.getValue((Property)Y_OFFSET) == 0 && (Integer)blockState.getValue((Property)Z_OFFSET) == 1 ? new AlloyFurnaceBlockEntity(blockPos, blockState) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return (Integer)blockState.getValue((Property)X_OFFSET) == 0 && (Integer)blockState.getValue((Property)Y_OFFSET) == 0 && (Integer)blockState.getValue((Property)Z_OFFSET) == 1 ? AlloyFurnaceBlock.createTickerHelper(blockEntityType, ESBlockEntities.ALLOY_FURNACE.get(), AlloyFurnaceBlockEntity::tick) : null;
    }

    public WorldlyContainer getContainer(BlockState state, LevelAccessor level, BlockPos pos) {
        int rotatedZ;
        Direction facing = (Direction)state.getValue((Property)FACING);
        int x = (Integer)state.getValue((Property)X_OFFSET);
        int y = (Integer)state.getValue((Property)Y_OFFSET);
        int z = (Integer)state.getValue((Property)Z_OFFSET) - 1;
        Vec3 rotated = new Vec3((double)x, 0.0, (double)z).yRot((float)(((int)(-facing.toYRot()) + 90) % 360) * ((float)Math.PI / 180));
        int rotatedX = Math.round((float)rotated.x);
        BlockPos centerPos = pos.offset(-rotatedX, -y, -(rotatedZ = Math.round((float)rotated.z)));
        BlockEntity blockEntity = level.getBlockEntity(centerPos);
        if (blockEntity instanceof AlloyFurnaceBlockEntity) {
            AlloyFurnaceBlockEntity entity = (AlloyFurnaceBlockEntity)blockEntity;
            return entity;
        }
        return new EmptyContainer();
    }

    static class EmptyContainer
    extends SimpleContainer
    implements WorldlyContainer {
        public EmptyContainer() {
            super(0);
        }

        public int[] getSlotsForFace(Direction side) {
            return new int[0];
        }

        public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
            return false;
        }

        public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
            return false;
        }
    }
}

