/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.neoforge.common.platform;

import cjminecraft.doubleslabs.api.DoubleSlabsPlugin;
import cjminecraft.doubleslabs.api.IDoubleSlabsPlugin;
import cjminecraft.doubleslabs.common.platform.services.IPlatformPluginHelper;
import java.lang.reflect.Constructor;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class NeoForgePluginHelper
implements IPlatformPluginHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public List<IDoubleSlabsPlugin> getPlugins() {
        return NeoForgePluginHelper.getInstances(DoubleSlabsPlugin.class, IDoubleSlabsPlugin.class);
    }

    public static <T> List<T> getInstances(Class<?> annotation, Class<T> instance) {
        Type type = Type.getType(annotation);
        List scanData = ModList.get().getAllScanData();
        LinkedHashSet pluginClassNames = new LinkedHashSet();
        scanData.stream().map(datum -> datum.getAnnotations().stream().filter(a -> Objects.equals(a.annotationType(), type)).map(ModFileScanData.AnnotationData::memberName).collect(Collectors.toSet())).forEach(pluginClassNames::addAll);
        return pluginClassNames.stream().map(className -> {
            try {
                Class<?> asmClass = Class.forName(className);
                Class asmInstanceClass = asmClass.asSubclass(instance);
                Constructor constructor = asmInstanceClass.getDeclaredConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            catch (LinkageError | ReflectiveOperationException e) {
                LOGGER.error("Failed to load: {}", className, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

