/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.library.plugins.vanilla.helpers;

import cjminecraft.doubleslabs.api.helpers.IHorizontalSlabHelper;
import cjminecraft.doubleslabs.api.state.Half;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class MinecraftSlabHelper
implements IHorizontalSlabHelper {
    @Override
    public boolean isHorizontalSlab(Block block) {
        return this.isHorizontalSlab(block.defaultBlockState());
    }

    @Override
    public boolean isHorizontalSlab(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.SLAB_TYPE);
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        BlockItem blockItem;
        return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() != null && this.isHorizontalSlab(blockItem.getBlock().defaultBlockState());
    }

    @Override
    public Half getHalf(BlockState state) {
        return switch ((SlabType)state.getValue((Property)BlockStateProperties.SLAB_TYPE)) {
            default -> throw new MatchException(null, null);
            case SlabType.BOTTOM -> Half.NEGATIVE;
            case SlabType.TOP -> Half.POSITIVE;
            case SlabType.DOUBLE -> throw new IllegalStateException("Cannot get the half for a double slab");
        };
    }

    @Override
    public boolean isDoubleSlab(BlockState state) {
        return state.getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.DOUBLE;
    }

    @Override
    public BlockState getStateForHalf(BlockState state, Half half) {
        return (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(half == Half.POSITIVE ? SlabType.TOP : SlabType.BOTTOM));
    }
}

