/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.hooks;

import cjminecraft.doubleslabs.api.helpers.IHorizontalSlabHelper;
import cjminecraft.doubleslabs.api.helpers.ISlabHelper;
import cjminecraft.doubleslabs.api.helpers.IVerticalSlabHelper;
import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.IDynamicSlabStateContainer;
import cjminecraft.doubleslabs.api.state.VerticalSlabState;
import cjminecraft.doubleslabs.api.state.VerticalSlabType;
import cjminecraft.doubleslabs.common.Internal;
import cjminecraft.doubleslabs.common.block.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlockEntities;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class PlacementHooks {
    public static Optional<ItemInteractionResult> useItemOnBlock(@Nullable Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (player == null) {
            return Optional.empty();
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.isEmpty()) {
            return Optional.empty();
        }
        BlockPos clickedPos = hitResult.getBlockPos();
        Direction clickedFace = hitResult.getDirection();
        BlockState clickedState = level.getBlockState(clickedPos);
        return PlacementHooks.useItemOnBlock(level, clickedState, clickedPos, clickedFace, player, itemInHand, hand, hitResult);
    }

    private static Optional<ItemInteractionResult> useItemOnBlock(Level level, BlockState clickedBlockState, BlockPos clickedPos, Direction clickedFace, Player player, ItemStack itemInHand, InteractionHand hand, BlockHitResult blockHitResult) {
        return PlacementHooks.tryUseHorizontalSlab(level, clickedBlockState, clickedPos, clickedFace, player, itemInHand, hand, blockHitResult).or(() -> PlacementHooks.tryUseVerticalSlab(level, clickedBlockState, clickedPos, clickedFace, player, itemInHand, hand, blockHitResult));
    }

    private static Optional<ItemInteractionResult> tryUseVerticalSlab(Level level, BlockState clickedBlockState, BlockPos clickedPos, Direction clickedFace, Player player, ItemStack itemInHand, InteractionHand hand, BlockHitResult blockHitResult) {
        ISlabHelper slabHelper = Internal.getSlabHelper();
        Optional<IVerticalSlabHelper> optionalItemInHandSlabHelper = slabHelper.getVerticalSlabHelper(itemInHand);
        if (optionalItemInHandSlabHelper.isPresent()) {
            BlockPos posRelativeToClickedFace;
            BlockState stateRelativeToClickedFace;
            IVerticalSlabHelper itemInHandSlabHelper = optionalItemInHandSlabHelper.get();
            if (clickedFace.getAxis().isHorizontal()) {
                IVerticalSlabHelper clickedBlockSlabHelper;
                VerticalSlabState clickedVerticalSlabState;
                Optional<IVerticalSlabHelper> optionalClickedBlockSlabHelper;
                if (clickedBlockState.is((Block)DSBlocks.VERTICAL_SLAB.get())) {
                    Direction facingDirection;
                    VerticalSlabType type = (VerticalSlabType)((Object)clickedBlockState.getValue(VerticalSlabBlock.TYPE));
                    Direction.Axis axis = (Direction.Axis)clickedBlockState.getValue(VerticalSlabBlock.AXIS);
                    if (type != VerticalSlabType.DOUBLE && (facingDirection = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)type.toAxisDirection())) == clickedFace.getOpposite()) {
                        return PlacementHooks.tryCombineDynamicVerticalSlab(level, clickedBlockState, clickedPos, player, itemInHand, hand, blockHitResult, itemInHandSlabHelper);
                    }
                }
                if ((optionalClickedBlockSlabHelper = slabHelper.getVerticalSlabHelper(clickedBlockState)).isPresent() && !(clickedVerticalSlabState = (clickedBlockSlabHelper = optionalClickedBlockSlabHelper.get()).getVerticalSlabState((BlockGetter)level, clickedPos, clickedBlockState)).isDouble() && clickedVerticalSlabState.getFacingDirection() == clickedFace.getOpposite()) {
                    return PlacementHooks.tryCombineVerticalSlabs(level, clickedBlockState, clickedPos, player, itemInHand, hand, blockHitResult, clickedBlockSlabHelper, itemInHandSlabHelper);
                }
            }
            if ((stateRelativeToClickedFace = level.getBlockState(posRelativeToClickedFace = clickedPos.relative(clickedFace))).is((Block)DSBlocks.VERTICAL_SLAB.get())) {
                return PlacementHooks.tryCombineDynamicVerticalSlab(level, stateRelativeToClickedFace, posRelativeToClickedFace, player, itemInHand, hand, blockHitResult, itemInHandSlabHelper);
            }
            Optional<IVerticalSlabHelper> optionalSlabHelperRelativeToClickedFace = slabHelper.getVerticalSlabHelper(stateRelativeToClickedFace);
            if (optionalSlabHelperRelativeToClickedFace.isPresent()) {
                return PlacementHooks.tryCombineVerticalSlabs(level, stateRelativeToClickedFace, posRelativeToClickedFace, player, itemInHand, hand, blockHitResult, optionalSlabHelperRelativeToClickedFace.get(), itemInHandSlabHelper);
            }
        }
        return Optional.empty();
    }

    private static Optional<ItemInteractionResult> tryCombineDynamicVerticalSlab(Level level, BlockState dynamicVerticalSlabState, BlockPos slabPos, Player player, ItemStack itemInHand, InteractionHand hand, BlockHitResult blockHitResult, IVerticalSlabHelper slabItemHelper) {
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(player, hand, itemInHand, blockHitResult);
        BlockState stateFromSlabItem = slabItemHelper.getStateFromStack(itemInHand, blockPlaceContext);
        if (stateFromSlabItem == null) {
            return Optional.empty();
        }
        Direction.Axis axis = (Direction.Axis)dynamicVerticalSlabState.getValue(VerticalSlabBlock.AXIS);
        VerticalSlabType type = (VerticalSlabType)((Object)dynamicVerticalSlabState.getValue(VerticalSlabBlock.TYPE));
        VerticalSlabType slabToPlaceType = type.getOpposite();
        Half slabToPlaceHalf = slabToPlaceType.getHalf();
        VerticalSlabState verticalSlabStateToPlace = new VerticalSlabState(axis, slabToPlaceType);
        BlockState slabToPlaceState = slabItemHelper.getStateForVerticalSlabState((BlockGetter)level, slabPos, stateFromSlabItem, verticalSlabStateToPlace);
        if (!level.setBlockAndUpdate(slabPos, (BlockState)dynamicVerticalSlabState.setValue(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE)))) {
            return Optional.empty();
        }
        PlacementHooks.handleBlockPlaced(level, player, slabToPlaceState, slabPos, itemInHand);
        Optional optionalDynamicSlabBlockEntity = level.getBlockEntity(slabPos, DSBlockEntities.DYNAMIC_SLAB.get());
        return optionalDynamicSlabBlockEntity.map(dynamicSlabBlockEntity -> {
            ((IDynamicSlabStateContainer)dynamicSlabBlockEntity).setBlockState(slabToPlaceHalf, slabToPlaceState);
            if (slabToPlaceState.hasBlockEntity()) {
                BlockEntity slabToPlaceBlockEntity = ((EntityBlock)slabToPlaceState.getBlock()).newBlockEntity(slabPos, slabToPlaceState);
                ((IDynamicSlabStateContainer)dynamicSlabBlockEntity).setBlockEntity(slabToPlaceHalf, slabToPlaceBlockEntity);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
    }

    private static Optional<ItemInteractionResult> tryCombineVerticalSlabs(Level level, BlockState slabBlockState, BlockPos slabPos, Player player, ItemStack itemInHand, InteractionHand hand, BlockHitResult blockHitResult, IVerticalSlabHelper slabBlockHelper, IVerticalSlabHelper slabItemHelper) {
        ISlabHelper slabHelper = Internal.getSlabHelper();
        VerticalSlabState slabVerticalSlabState = slabBlockHelper.getVerticalSlabState((BlockGetter)level, slabPos, slabBlockState);
        if (slabVerticalSlabState.isDouble()) {
            return Optional.empty();
        }
        if (slabHelper.areSameTypeOfSlab(slabBlockState, slabBlockHelper, itemInHand, slabItemHelper)) {
            return Optional.empty();
        }
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(player, hand, itemInHand, blockHitResult);
        BlockState stateFromSlabItem = slabItemHelper.getStateFromStack(itemInHand, blockPlaceContext);
        if (stateFromSlabItem == null) {
            return Optional.empty();
        }
        VerticalSlabType slabBlockType = slabVerticalSlabState.type();
        Half slabBlockHalf = slabBlockType.getHalf();
        VerticalSlabType slabToPlaceType = slabVerticalSlabState.type().getOpposite();
        Half slabToPlaceHalf = slabToPlaceType.getHalf();
        VerticalSlabState verticalSlabStateToPlace = new VerticalSlabState(slabVerticalSlabState.axis(), slabToPlaceType);
        BlockState slabToPlaceState = slabItemHelper.getStateForVerticalSlabState((BlockGetter)level, slabPos, stateFromSlabItem, verticalSlabStateToPlace);
        BlockEntity existingBlockEntity = level.getBlockEntity(slabPos);
        BlockState dynamicVerticalSlabState = (BlockState)((BlockState)DSBlocks.VERTICAL_SLAB.get().defaultBlockState().setValue(VerticalSlabBlock.AXIS, (Comparable)slabVerticalSlabState.axis())).setValue(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE));
        if (!level.setBlockAndUpdate(slabPos, dynamicVerticalSlabState)) {
            return Optional.empty();
        }
        PlacementHooks.handleBlockPlaced(level, player, slabToPlaceState, slabPos, itemInHand);
        Optional optionalDynamicSlabBlockEntity = level.getBlockEntity(slabPos, DSBlockEntities.DYNAMIC_SLAB.get());
        return optionalDynamicSlabBlockEntity.map(dynamicSlabBlockEntity -> {
            ((IDynamicSlabStateContainer)dynamicSlabBlockEntity).setBlockState(slabBlockHalf, slabBlockState);
            ((IDynamicSlabStateContainer)dynamicSlabBlockEntity).setBlockEntity(slabBlockHalf, existingBlockEntity);
            ((IDynamicSlabStateContainer)dynamicSlabBlockEntity).setBlockState(slabToPlaceHalf, slabToPlaceState);
            if (slabToPlaceState.hasBlockEntity()) {
                BlockEntity slabToPlaceBlockEntity = ((EntityBlock)slabToPlaceState.getBlock()).newBlockEntity(slabPos, slabToPlaceState);
                ((IDynamicSlabStateContainer)dynamicSlabBlockEntity).setBlockEntity(slabToPlaceHalf, slabToPlaceBlockEntity);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
    }

    private static Optional<ItemInteractionResult> tryUseHorizontalSlab(Level level, BlockState clickedBlockState, BlockPos clickedPos, Direction clickedFace, Player player, ItemStack itemInHand, InteractionHand hand, BlockHitResult blockHitResult) {
        ISlabHelper slabHelper = Internal.getSlabHelper();
        Optional<IHorizontalSlabHelper> optionalItemInHandSlabHelper = slabHelper.getHorizontalSlabHelper(itemInHand);
        if (optionalItemInHandSlabHelper.isPresent()) {
            Half half;
            IHorizontalSlabHelper clickedBlockSlabHelper;
            IHorizontalSlabHelper itemInHandSlabHelper = optionalItemInHandSlabHelper.get();
            Optional<IHorizontalSlabHelper> optionalClickedBlockSlabHelper = slabHelper.getHorizontalSlabHelper(clickedBlockState);
            if (clickedFace.getAxis().isVertical() && optionalClickedBlockSlabHelper.isPresent() && !(clickedBlockSlabHelper = optionalClickedBlockSlabHelper.get()).isDoubleSlab(clickedBlockState) && ((half = clickedBlockSlabHelper.getHalf(clickedBlockState)) == Half.NEGATIVE && clickedFace == Direction.UP || half == Half.POSITIVE && clickedFace == Direction.DOWN)) {
                return PlacementHooks.tryCombineHorizontalSlabs(level, clickedBlockState, clickedPos, player, itemInHand, hand, blockHitResult, clickedBlockSlabHelper, itemInHandSlabHelper);
            }
            BlockPos posRelativeToClickedFace = clickedPos.relative(clickedFace);
            BlockState stateRelativeToClickedFace = level.getBlockState(posRelativeToClickedFace);
            Optional<IHorizontalSlabHelper> optionalSlabHelperRelativeToClickedFace = slabHelper.getHorizontalSlabHelper(stateRelativeToClickedFace);
            if (optionalSlabHelperRelativeToClickedFace.isPresent()) {
                return PlacementHooks.tryCombineHorizontalSlabs(level, stateRelativeToClickedFace, posRelativeToClickedFace, player, itemInHand, hand, blockHitResult, optionalSlabHelperRelativeToClickedFace.get(), itemInHandSlabHelper);
            }
        }
        return Optional.empty();
    }

    private static Optional<ItemInteractionResult> tryCombineHorizontalSlabs(Level level, BlockState slabBlockState, BlockPos slabPos, Player player, ItemStack itemInHand, InteractionHand hand, BlockHitResult blockHitResult, IHorizontalSlabHelper slabBlockHelper, IHorizontalSlabHelper slabItemHelper) {
        ISlabHelper slabHelper = Internal.getSlabHelper();
        if (slabBlockHelper.isDoubleSlab(slabBlockState)) {
            return Optional.empty();
        }
        if (slabHelper.areSameTypeOfSlab(slabBlockState, slabBlockHelper, itemInHand, slabItemHelper)) {
            return Optional.empty();
        }
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(player, hand, itemInHand, blockHitResult);
        BlockState stateFromSlabItem = slabItemHelper.getStateFromStack(itemInHand, blockPlaceContext);
        if (stateFromSlabItem == null) {
            return Optional.empty();
        }
        Half slabBlockHalf = slabBlockHelper.getHalf(slabBlockState);
        Half slabToPlaceHalf = slabBlockHalf.getOpposite();
        BlockState slabToPlaceState = slabItemHelper.getStateForHalf(stateFromSlabItem, slabToPlaceHalf);
        boolean bothSlabsOcclude = slabToPlaceState.canOcclude() && slabBlockState.canOcclude();
        BlockEntity existingBlockEntity = level.getBlockEntity(slabPos);
        BlockState dynamicDoubleSlabState = (bothSlabsOcclude ? DSBlocks.MIXED_SLAB.get() : DSBlocks.TRANSPARENT_MIXED_SLAB.get()).defaultBlockState();
        if (!level.setBlock(slabPos, dynamicDoubleSlabState, 3)) {
            return Optional.empty();
        }
        PlacementHooks.handleBlockPlaced(level, player, slabToPlaceState, slabPos, itemInHand);
        Optional optionalDynamicSlabBlockEntity = level.getBlockEntity(slabPos, DSBlockEntities.DYNAMIC_SLAB.get());
        return optionalDynamicSlabBlockEntity.map(dynamicSlabBlockEntity -> {
            ((IDynamicSlabStateContainer)dynamicSlabBlockEntity).setBlockState(slabBlockHalf, slabBlockState);
            ((IDynamicSlabStateContainer)dynamicSlabBlockEntity).setBlockEntity(slabBlockHalf, existingBlockEntity);
            ((IDynamicSlabStateContainer)dynamicSlabBlockEntity).setBlockState(slabToPlaceHalf, slabToPlaceState);
            if (slabToPlaceState.hasBlockEntity()) {
                BlockEntity slabToPlaceBlockEntity = ((EntityBlock)slabToPlaceState.getBlock()).newBlockEntity(slabPos, slabToPlaceState);
                ((IDynamicSlabStateContainer)dynamicSlabBlockEntity).setBlockEntity(slabToPlaceHalf, slabToPlaceBlockEntity);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
    }

    private static void handleBlockPlaced(Level level, Player player, BlockState statePlaced, BlockPos pos, ItemStack itemInHand) {
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, pos, itemInHand);
        }
        SoundType soundType = statePlaced.getSoundType();
        level.playSound(player, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)statePlaced));
        if (!player.isCreative()) {
            itemInHand.shrink(1);
        }
    }
}

