/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.hooks;

import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.common.hooks.DynamicSlabBlockHooks;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;

public class DynamicSlabBlockClientHooks
extends DynamicSlabBlockHooks {
    public static BlockColor getBlockColour() {
        return (state, level, pos, tintIndex) -> {
            if (level == null || pos == null || tintIndex < 0) {
                return -1;
            }
            BlockColors blockColours = Minecraft.getInstance().getBlockColors();
            return DynamicSlabBlockClientHooks.getDynamicSlabStateContainer((BlockGetter)level, pos).flatMap(container -> {
                if (tintIndex >= 1000) {
                    return container.callOnBlockState(Half.POSITIVE, slabState -> blockColours.getColor(slabState, level, pos, tintIndex - 1000));
                }
                return container.callOnBlockState(Half.NEGATIVE, slabState -> blockColours.getColor(slabState, level, pos, tintIndex));
            }).orElse(-1);
        };
    }

    public static boolean addDestroyEffects(BlockGetter blockGetter, BlockPos slabPos, ParticleEngine particleEngine) {
        return DynamicSlabBlockClientHooks.getDynamicSlabStateContainer(blockGetter, slabPos).map(container -> {
            container.runOnBlockStates(state -> particleEngine.destroy(slabPos, state));
            return true;
        }).orElse(false);
    }

    public static Function<BakedQuad, BakedQuad> withCorrectTint(Half half) {
        return switch (half) {
            default -> throw new MatchException(null, null);
            case Half.POSITIVE -> quad -> quad.isTinted() ? new BakedQuad(quad.getVertices(), quad.getTintIndex() + 1000, quad.getDirection(), quad.getSprite(), quad.isShade()) : quad;
            case Half.NEGATIVE -> quad -> quad;
        };
    }
}

