/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.hooks;

import cjminecraft.doubleslabs.api.helpers.IHorizontalSlabHelper;
import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.VerticalSlabType;
import cjminecraft.doubleslabs.common.Internal;
import cjminecraft.doubleslabs.common.block.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.block.entity.DynamicSlabBlockEntity;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ClientRenderingHooks {
    public static boolean renderBlockHighlight(PoseStack poseStack, double camX, double camY, double camZ, Supplier<VertexConsumer> vertexConsumer) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.player == null || minecraft.hitResult == null) {
            return false;
        }
        ClientLevel level = minecraft.level;
        LocalPlayer player = minecraft.player;
        if (player.isCreative() && !player.isCrouching()) {
            return false;
        }
        BlockHitResult hitResult = (BlockHitResult)minecraft.hitResult;
        BlockState state = level.getBlockState(hitResult.getBlockPos());
        if (ClientRenderingHooks.isDoubleSlab(state)) {
            double x = (double)hitResult.getBlockPos().getX() - camX;
            double y = (double)hitResult.getBlockPos().getY() - camY;
            double z = (double)hitResult.getBlockPos().getZ() - camZ;
            if (hitResult.getLocation().y - (double)hitResult.getBlockPos().getY() > 0.5) {
                y += 0.5;
            }
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer.get(), (double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 0.5), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            return true;
        }
        if (state.is((Block)DSBlocks.VERTICAL_SLAB.get()) && state.getValue(VerticalSlabBlock.TYPE) == VerticalSlabType.DOUBLE) {
            double x = (double)hitResult.getBlockPos().getX() - camX;
            double y = (double)hitResult.getBlockPos().getY() - camY;
            double z = (double)hitResult.getBlockPos().getZ() - camZ;
            Direction.Axis axis = (Direction.Axis)state.getValue(VerticalSlabBlock.AXIS);
            switch (axis) {
                case X: {
                    if (hitResult.getLocation().x - (double)hitResult.getBlockPos().getX() > 0.5) {
                        x += 0.5;
                    }
                    LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer.get(), (double)x, (double)y, (double)z, (double)(x + 0.5), (double)(y + 1.0), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    break;
                }
                case Z: {
                    if (hitResult.getLocation().z - (double)hitResult.getBlockPos().getZ() > 0.5) {
                        z += 0.5;
                    }
                    LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer.get(), (double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 0.5), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isDoubleSlab(BlockState state) {
        if (state.is(DSBlocks.MIXED_SLABS)) {
            return true;
        }
        Optional<IHorizontalSlabHelper> slabHelper = Internal.getSlabHelper().getHorizontalSlabHelper(state);
        return slabHelper.isPresent() && slabHelper.get().isDoubleSlab(state);
    }

    public static void addTextToDebugScreenOverlay(List<String> text) {
        BlockHitResult blockHitResult;
        BlockPos hitPos;
        BlockEntity blockEntity;
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkState((minecraft.getCameraEntity() != null ? 1 : 0) != 0, (Object)"The camera entity must be nonnull to be able to add debug text");
        Preconditions.checkState((minecraft.level != null ? 1 : 0) != 0, (Object)"The level must be nonnull");
        HitResult hitResult = minecraft.getCameraEntity().pick(20.0, 0.0f, false);
        if (hitResult.getType() == HitResult.Type.BLOCK && hitResult instanceof BlockHitResult && (blockEntity = minecraft.level.getBlockEntity(hitPos = (blockHitResult = (BlockHitResult)hitResult).getBlockPos())) instanceof DynamicSlabBlockEntity) {
            DynamicSlabBlockEntity dynamicSlabBlockEntity = (DynamicSlabBlockEntity)blockEntity;
            text.add("");
            text.add(String.valueOf(ChatFormatting.UNDERLINE) + "Dynamic Slab Types");
            dynamicSlabBlockEntity.runOnBlockStates((half, state) -> ClientRenderingHooks.addBlockStateToDebugScreenOverlay(half, state, text));
            dynamicSlabBlockEntity.runOnBlockEntities((half, entity) -> ClientRenderingHooks.addBlockEntityToDebugScreenOverlay(half, entity, text));
        }
    }

    private static String getHalfPrefix(Half half) {
        return String.valueOf(ChatFormatting.ITALIC) + half.toString() + String.valueOf(ChatFormatting.RESET) + ": ";
    }

    private static void addBlockStateToDebugScreenOverlay(Half half, BlockState state, List<String> text) {
        text.add(ClientRenderingHooks.getHalfPrefix(half) + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock())));
    }

    private static void addBlockEntityToDebugScreenOverlay(Half half, @Nullable BlockEntity blockEntity, List<String> text) {
        if (blockEntity == null) {
            text.add(ClientRenderingHooks.getHalfPrefix(half) + String.valueOf(ChatFormatting.RED) + "null");
        } else {
            text.add(ClientRenderingHooks.getHalfPrefix(half) + String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)blockEntity.getType())));
        }
    }

    public static void crackParticle(BlockPos pos, BlockState state, Direction side, ClientLevel level, ParticleEngine particleEngine) {
        if (state.getRenderShape() != RenderShape.INVISIBLE && state.shouldSpawnTerrainParticles()) {
            int i = pos.getX();
            int j = pos.getY();
            int k = pos.getZ();
            AABB aabb = state.getShape((BlockGetter)level, pos).bounds();
            double d0 = (double)i + level.random.nextDouble() * (aabb.maxX - aabb.minX - (double)0.2f) + (double)0.1f + aabb.minX;
            double d1 = (double)j + level.random.nextDouble() * (aabb.maxY - aabb.minY - (double)0.2f) + (double)0.1f + aabb.minY;
            double d2 = (double)k + level.random.nextDouble() * (aabb.maxZ - aabb.minZ - (double)0.2f) + (double)0.1f + aabb.minZ;
            if (side == Direction.DOWN) {
                d1 = (double)j + aabb.minY - (double)0.1f;
            }
            if (side == Direction.UP) {
                d1 = (double)j + aabb.maxY + (double)0.1f;
            }
            if (side == Direction.NORTH) {
                d2 = (double)k + aabb.minZ - (double)0.1f;
            }
            if (side == Direction.SOUTH) {
                d2 = (double)k + aabb.maxZ + (double)0.1f;
            }
            if (side == Direction.WEST) {
                d0 = (double)i + aabb.minX - (double)0.1f;
            }
            if (side == Direction.EAST) {
                d0 = (double)i + aabb.maxX + (double)0.1f;
            }
            particleEngine.add(new TerrainParticle(level, d0, d1, d2, 0.0, 0.0, 0.0, state, pos).setPower(0.2f).scale(0.6f));
        }
    }
}

