/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.better_lib.util.common;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public abstract class BaseRow {
    protected final String name;
    protected int lx;
    protected int ly;
    protected int w;
    protected int h;

    public BaseRow(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract void drawContents(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract boolean click(double var1, double var3);

    public boolean mouseReleased(double mx, double my, int btn) {
        return false;
    }

    public boolean mouseDragged(double mx, double my, int btn, double dx, double dy) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return false;
    }

    public void render(GuiGraphics gfx, int x, int y, int w, int h, int mx, int my) {
        this.lx = x;
        this.ly = y;
        this.w = w;
        this.h = h;
        boolean hover = mx >= x && mx <= x + w && my >= y && my <= y + h;
        int bg1 = hover ? -12303292 : 0;
        int bg2 = hover ? -13619152 : -15066598;
        gfx.fillGradient(x + 4, y + 4, x + w - 4, y + h - 7, bg1, bg2);
        if (hover) {
            gfx.fill(x + 4, y + 4, x + w - 4, y + 5, -22016);
        }
        this.drawContents(gfx, x, y, w, h, mx, my);
    }

    protected void drawText(GuiGraphics gfx, String txt, int x, int y, int color) {
        gfx.drawString(Minecraft.getInstance().font, txt, x, y, color);
    }
}

