/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.dysoncubeproject;

import com.buuz135.dysoncubeproject.DCPAttachments;
import com.buuz135.dysoncubeproject.DCPContent;
import com.buuz135.dysoncubeproject.block.tile.EMRailEjectorBlockEntity;
import com.buuz135.dysoncubeproject.block.tile.RayReceiverBlockEntity;
import com.buuz135.dysoncubeproject.client.ClientSetup;
import com.buuz135.dysoncubeproject.datagen.DCPBlockTagsProvider;
import com.buuz135.dysoncubeproject.datagen.DCPBlockstateProvider;
import com.buuz135.dysoncubeproject.datagen.DCPLangItemProvider;
import com.buuz135.dysoncubeproject.datagen.DCPLootTableDataProvider;
import com.buuz135.dysoncubeproject.datagen.DCPRecipesProvider;
import com.buuz135.dysoncubeproject.network.ClientSubscribeSphereMessage;
import com.buuz135.dysoncubeproject.network.DysonSphereSyncMessage;
import com.buuz135.dysoncubeproject.world.DysonSphereProgressSavedData;
import com.buuz135.dysoncubeproject.world.DysonSphereStructure;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.slf4j.Logger;

@Mod(value="dysoncubeproject")
public class DysonCubeProject
extends ModuleController {
    public static final String MODID = "dysoncubeproject";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static NetworkHandler NETWORK = new NetworkHandler("dysoncubeproject");

    public DysonCubeProject(Dist dist, IEventBus modEventBus, ModContainer modContainer) {
        super(modContainer);
        NETWORK.registerMessage("dyson_sphere_sync", DysonSphereSyncMessage.class);
        NETWORK.registerMessage("client_subscribe_sphere", ClientSubscribeSphereMessage.class);
        if (dist == Dist.CLIENT) {
            ClientSetup.init();
        }
        EventManager.forge(LevelTickEvent.Pre.class).process(post -> {
            ServerLevel serverLevel;
            Level patt0$temp = post.getLevel();
            if (patt0$temp instanceof ServerLevel && (serverLevel = (ServerLevel)patt0$temp).dimensionTypeRegistration().getRegisteredName().equals(BuiltinDimensionTypes.OVERWORLD.location().toString())) {
                DysonSphereProgressSavedData data = DysonSphereProgressSavedData.get((Level)serverLevel);
                if (post.getLevel().getGameTime() % 4L == 0L) {
                    DysonSphereSyncMessage packet = new DysonSphereSyncMessage(data.save(new CompoundTag(), (HolderLookup.Provider)serverLevel.getServer().registryAccess()));
                    for (ServerPlayer player : serverLevel.getServer().getPlayerList().getPlayers()) {
                        NETWORK.sendTo((Message)packet, player);
                    }
                }
                data.getSpheres().values().forEach(DysonSphereStructure::generatePower);
                data.setDirty();
            }
        }).subscribe();
        EventManager.mod(RegisterCapabilitiesEvent.class).process(event -> {
            event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, blockPos, blockState, blockEntity, direction) -> {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (blockEntity instanceof EMRailEjectorBlockEntity) {
                        EMRailEjectorBlockEntity emRailEjectorBlockEntity = (EMRailEjectorBlockEntity)blockEntity;
                        if (direction == Direction.DOWN) {
                            return emRailEjectorBlockEntity.getInput();
                        }
                    }
                }
                return null;
            }, new Block[]{DCPContent.Blocks.EM_RAILEJECTOR_CONTROLLER.getBlock()});
            event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, blockPos, blockState, blockEntity, direction) -> {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (blockEntity instanceof EMRailEjectorBlockEntity) {
                        EMRailEjectorBlockEntity emRailEjectorBlockEntity = (EMRailEjectorBlockEntity)blockEntity;
                        if (direction == Direction.DOWN) {
                            return emRailEjectorBlockEntity.getPower();
                        }
                    }
                }
                return null;
            }, new Block[]{DCPContent.Blocks.EM_RAILEJECTOR_CONTROLLER.getBlock()});
            event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, blockPos, blockState, blockEntity, direction) -> {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    BlockEntity patt0$temp = level.getBlockEntity(blockPos.below());
                    if (patt0$temp instanceof EMRailEjectorBlockEntity) {
                        EMRailEjectorBlockEntity emRailEjectorBlockEntity = (EMRailEjectorBlockEntity)patt0$temp;
                        return emRailEjectorBlockEntity.getPower();
                    }
                }
                return null;
            }, new Block[]{DCPContent.Blocks.MULTIBLOCK_STRUCTURE.getBlock()});
            event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, blockPos, blockState, blockEntity, direction) -> {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (blockEntity instanceof RayReceiverBlockEntity) {
                        RayReceiverBlockEntity rayReceiverBlockEntity = (RayReceiverBlockEntity)blockEntity;
                        if (direction == Direction.DOWN) {
                            return rayReceiverBlockEntity.getEnergyStorageComponent();
                        }
                    }
                }
                return null;
            }, new Block[]{DCPContent.Blocks.RAY_RECEIVER_CONTROLLER.getBlock()});
        }).subscribe();
        EventManager.forge(RegisterCommandsEvent.class).process(event -> {
            CommandDispatcher dispatcher = event.getDispatcher();
            SuggestionProvider sphereIdSuggestions = (ctx, builder) -> {
                ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
                DysonSphereProgressSavedData data = DysonSphereProgressSavedData.get((Level)level);
                if (data != null) {
                    return SharedSuggestionProvider.suggest(data.getSpheres().keySet(), (SuggestionsBuilder)builder);
                }
                return SharedSuggestionProvider.suggest(List.of(), (SuggestionsBuilder)builder);
            };
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)MODID).requires(source -> source.hasPermission(4))).then(Commands.literal((String)"set").then(Commands.literal((String)"beams").then(Commands.argument((String)"sphereId", (ArgumentType)StringArgumentType.string()).suggests(sphereIdSuggestions).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerLevel level = source.getLevel();
                String sphereId = StringArgumentType.getString((CommandContext)ctx, (String)"sphereId");
                int input = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
                DysonSphereProgressSavedData data = DysonSphereProgressSavedData.get((Level)level);
                if (data == null) {
                    return 0;
                }
                DysonSphereStructure config = data.getSpheres().computeIfAbsent(sphereId, s -> new DysonSphereStructure());
                int clamped = Math.max(0, Math.min(input, config.getMaxBeams()));
                config.setBeams(clamped);
                data.setDirty();
                source.sendSuccess(() -> Component.literal((String)("Set beams for sphere '" + sphereId + "' to " + clamped)), true);
                return 1;
            })))))).then(Commands.literal((String)"set").then(Commands.literal((String)"panels").then(Commands.argument((String)"sphereId", (ArgumentType)StringArgumentType.string()).suggests(sphereIdSuggestions).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerLevel level = source.getLevel();
                String sphereId = StringArgumentType.getString((CommandContext)ctx, (String)"sphereId");
                int input = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
                DysonSphereProgressSavedData data = DysonSphereProgressSavedData.get((Level)level);
                if (data == null) {
                    return 0;
                }
                DysonSphereStructure config = data.getSpheres().computeIfAbsent(sphereId, s -> new DysonSphereStructure());
                int clamped = Math.max(0, Math.min(input, config.getMaxSolarPanels()));
                config.setSolarPanels(clamped);
                data.setDirty();
                source.sendSuccess(() -> Component.literal((String)("Set solar panels for sphere '" + sphereId + "' to " + clamped)), true);
                return 1;
            })))))).then(Commands.literal((String)"add").then(Commands.literal((String)"beams").then(Commands.argument((String)"sphereId", (ArgumentType)StringArgumentType.string()).suggests(sphereIdSuggestions).then(Commands.argument((String)"delta", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerLevel level = source.getLevel();
                String sphereId = StringArgumentType.getString((CommandContext)ctx, (String)"sphereId");
                int delta = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delta");
                DysonSphereProgressSavedData data = DysonSphereProgressSavedData.get((Level)level);
                if (data == null) {
                    return 0;
                }
                DysonSphereStructure config = data.getSpheres().computeIfAbsent(sphereId, s -> new DysonSphereStructure());
                int newVal = Math.max(0, Math.min(config.getBeams() + delta, config.getMaxBeams()));
                config.setBeams(newVal);
                data.setDirty();
                source.sendSuccess(() -> Component.literal((String)("Beams for sphere '" + sphereId + "' is now " + newVal)), true);
                return 1;
            })))))).then(Commands.literal((String)"add").then(Commands.literal((String)"panels").then(Commands.argument((String)"sphereId", (ArgumentType)StringArgumentType.string()).suggests(sphereIdSuggestions).then(Commands.argument((String)"delta", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerLevel level = source.getLevel();
                String sphereId = StringArgumentType.getString((CommandContext)ctx, (String)"sphereId");
                int delta = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delta");
                DysonSphereProgressSavedData data = DysonSphereProgressSavedData.get((Level)level);
                if (data == null) {
                    return 0;
                }
                DysonSphereStructure config = data.getSpheres().computeIfAbsent(sphereId, s -> new DysonSphereStructure());
                int newVal = Math.max(0, Math.min(config.getSolarPanels() + delta, config.getMaxSolarPanels()));
                config.setSolarPanels(newVal);
                data.setDirty();
                source.sendSuccess(() -> Component.literal((String)("Solar panels for sphere '" + sphereId + "' is now " + newVal)), true);
                return 1;
            }))))));
        }).subscribe();
        DCPAttachments.DR.register(modEventBus);
    }

    protected void initModules() {
        this.addCreativeTab("main", () -> new ItemStack((ItemLike)DCPContent.Blocks.EM_RAILEJECTOR_CONTROLLER), "dyson_cube_project", DCPContent.TAB);
        DCPContent.Blocks.init();
        DCPContent.Items.init();
        DCPContent.Sounds.init();
    }

    public void addDataProvider(GatherDataEvent event) {
        super.addDataProvider(event);
        event.addProvider((DataProvider)new DCPBlockstateProvider(event.getGenerator(), MODID, event.getExistingFileHelper()));
        event.addProvider((DataProvider)new DCPLangItemProvider(event.getGenerator(), MODID, "en_us"));
        event.addProvider((DataProvider)new DCPRecipesProvider(event.getGenerator(), () -> new ArrayList(), event.getLookupProvider()));
        event.addProvider((DataProvider)new DCPLootTableDataProvider(event.getGenerator(), () -> List.of(DCPContent.Blocks.EM_RAILEJECTOR_CONTROLLER.getBlock(), DCPContent.Blocks.RAY_RECEIVER_CONTROLLER.getBlock()), event.getLookupProvider()));
        event.addProvider((DataProvider)new DCPBlockTagsProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), MODID, event.getExistingFileHelper()));
    }
}

