/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.planting.plantable;

import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.machines.component.farmer.planting.FarmerPlantable;
import net.swedz.extended_industrialization.machines.component.farmer.planting.PlantingContext;

public final class StandardFarmerPlantable
implements FarmerPlantable {
    private static boolean supportsBlockType(Block block) {
        if (block instanceof GrowingPlantBlock) {
            GrowingPlantBlock plant = (GrowingPlantBlock)block;
            return plant.growthDirection == Direction.UP;
        }
        return true;
    }

    public boolean matches(PlantingContext context) {
        BlockItem item;
        Item item2;
        ItemStack stack = context.stack();
        return !stack.isEmpty() && stack.is(EITags.Items.FARMER_PLANTABLE) && (item2 = stack.getItem()) instanceof BlockItem && StandardFarmerPlantable.supportsBlockType((item = (BlockItem)item2).getBlock());
    }

    @Override
    public boolean canPlant(PlantingContext context) {
        return FarmerPlantable.getPlacementStateBlockItem(context) != null;
    }

    @Override
    public void plant(PlantingContext context) {
        BlockState crop = FarmerPlantable.getPlacementStateBlockItem(context);
        context.tile().crop().setBlock(context.level(), crop, 3, (Holder.Reference<GameEvent>)GameEvent.BLOCK_PLACE, crop);
    }
}

