/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public final class FarmerBlock {
    private final BlockPos pos;
    private BlockState state;

    FarmerBlock(BlockPos pos) {
        this.pos = pos;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public BlockState state(Level level) {
        if (this.state == null) {
            this.updateState(level);
        }
        return this.state;
    }

    public void updateState(BlockState state) {
        this.state = state;
    }

    public void updateState(Level level) {
        this.updateState(level.getBlockState(this.pos));
    }

    public void setBlock(Level level, BlockState state, int flags) {
        level.setBlock(this.pos, state, flags);
        this.updateState(state);
    }

    public void setBlock(Level level, BlockState state, int flags, Holder.Reference<GameEvent> gameEvent, BlockState affectedState) {
        this.setBlock(level, state, flags);
        level.gameEvent(gameEvent, this.pos, GameEvent.Context.of((BlockState)affectedState));
    }

    public void markDirty() {
        this.state = null;
    }
}

