/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer;

import aztech.modern_industrialization.inventory.ChangeListener;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponentPlantableStacks;
import net.swedz.extended_industrialization.machines.component.farmer.planting.FarmerPlantable;

public final class PlantableConfigurableItemStack
extends ChangeListener {
    private final FarmerComponentPlantableStacks parent;
    private final ConfigurableItemStack stack;
    private Item lastUpdateItem;
    private Optional<FarmerPlantable> plantable = Optional.empty();

    PlantableConfigurableItemStack(FarmerComponentPlantableStacks parent, ConfigurableItemStack stack) {
        this.parent = parent;
        this.stack = stack;
    }

    public ConfigurableItemStack getStack() {
        return this.stack;
    }

    public ItemVariant getItemVariant() {
        return (this.stack.isPlayerLocked() || this.stack.isMachineLocked()) && ((ItemVariant)this.stack.getResource()).isBlank() ? ItemVariant.of((ItemLike)((ItemLike)this.stack.getLockedInstance())) : (ItemVariant)this.stack.getResource();
    }

    public Item getItem() {
        return this.getItemVariant().getItem();
    }

    public boolean isPlantable() {
        return this.plantable.isPresent();
    }

    public FarmerPlantable asPlantable() {
        return this.plantable.orElseThrow(() -> new IllegalStateException("Tried to get plantable of non-plantable itemStack"));
    }

    protected void onChange() {
        ItemVariant itemVariant = this.getItemVariant();
        Item item = itemVariant.getItem();
        if (this.lastUpdateItem != item) {
            this.plantable = this.parent.getFarmer().getPlantableBehaviorHolder().behavior(itemVariant.toStack());
        }
        this.lastUpdateItem = item;
    }

    protected boolean isValid(Object token) {
        return true;
    }
}

