/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.chainer.link;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;

public final class LinkContext {
    private final ChainerLinks links;
    private final BlockPos pos;
    private final Optional<BlockState> blockState;
    private final Optional<BlockEntity> blockEntity;
    private final Optional<ItemStack> itemStack;

    private LinkContext(ChainerLinks links, BlockPos pos, Optional<BlockState> blockState, Optional<BlockEntity> blockEntity, Optional<ItemStack> itemStack) {
        this.links = links;
        this.pos = pos;
        this.blockState = blockState;
        this.blockEntity = blockEntity;
        this.itemStack = itemStack;
    }

    public static LinkContext of(ChainerLinks links, BlockPos pos) {
        return new LinkContext(links, pos, Optional.of(links.level().getBlockState(pos)), Optional.ofNullable(links.level().getBlockEntity(pos)), Optional.empty());
    }

    public static LinkContext of(ChainerLinks links, ItemStack itemStack) {
        LinkContext context;
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            context = new LinkContext(links, BlockPos.ZERO, Optional.of(block.defaultBlockState()), Optional.empty(), Optional.of(itemStack));
        } else {
            context = new LinkContext(links, BlockPos.ZERO, Optional.empty(), Optional.empty(), Optional.of(itemStack));
        }
        return context;
    }

    public ChainerLinks links() {
        return this.links;
    }

    public Level level() {
        return this.links.level();
    }

    public BlockPos pos() {
        return this.pos;
    }

    public BlockState blockState() {
        return this.blockState.orElseThrow();
    }

    public boolean hasBlockState() {
        return this.blockState.isPresent();
    }

    public BlockEntity blockEntity() {
        return this.blockEntity.orElseThrow();
    }

    public boolean hasBlockEntity() {
        return this.blockEntity.isPresent();
    }

    public ItemStack itemStack() {
        return this.itemStack.orElseThrow();
    }

    public boolean hasItemStack() {
        return this.itemStack.isPresent();
    }
}

