/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.DropableComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public final class TransformerTierComponent
implements MachineComponent.ServerOnly,
DropableComponent {
    private final boolean isFrom;
    private ItemStack stack = ItemStack.EMPTY;
    private CableTier tier = CableTier.LV;

    public TransformerTierComponent(boolean isFrom) {
        this.isFrom = isFrom;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public CableTier getTier() {
        return this.tier;
    }

    public boolean canInsertEu(CableTier tier) {
        return this.tier == tier;
    }

    private void setCasingInternal(ItemStack stack) {
        this.stack = stack;
        this.tier = TransformerTierComponent.getTierFromCasing(stack);
        if (this.tier == null) {
            this.tier = CableTier.LV;
        }
    }

    private String nbtKey() {
        return "casing_" + (this.isFrom ? "from" : "to");
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(this.nbtKey(), this.stack.saveOptional(registries));
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.setCasingInternal(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(this.nbtKey())));
    }

    public ItemStack getDrop() {
        return this.getStack();
    }

    private void playCasingPlaceSound(MachineBlockEntity blockEntity) {
        ResourceLocation blockKey = this.tier.itemKey;
        if (blockKey == null) {
            return;
        }
        BuiltInRegistries.BLOCK.getOptional(blockKey).ifPresent(block -> {
            BlockState casingState = block.defaultBlockState();
            SoundType group = casingState.getSoundType();
            SoundEvent sound = group.getBreakSound();
            blockEntity.getLevel().playSound(null, blockEntity.getBlockPos(), sound, SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 4.0f, group.getPitch() * 0.8f);
        });
    }

    public void setCasing(MachineBlockEntity blockEntity, ItemStack stack) {
        this.setCasingInternal(stack);
        blockEntity.setChanged();
        blockEntity.sync();
        blockEntity.getLevel().updateNeighborsAt(blockEntity.getBlockPos(), Blocks.AIR);
        this.playCasingPlaceSound(blockEntity);
    }

    public static CableTier getTierFromCasing(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        for (CableTier tier : CableTier.allTiers()) {
            if (tier.itemKey == null || !tier.itemKey.equals((Object)itemKey)) continue;
            return tier;
        }
        return null;
    }
}

