/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.MachineOverlay;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.helper.EnergyHelper;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.machines.component.solar.SolarSunlightComponent;
import net.swedz.extended_industrialization.machines.component.solar.electric.SolarGeneratorComponent;
import net.swedz.extended_industrialization.machines.guicomponent.solarefficiency.SolarEfficiencyBar;

public final class SolarPanelMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
EnergyComponentHolder {
    private static final int CELL_X = 58;
    private static final int CELL_Y = 40;
    private static final int WATER_X = 38;
    private static final int WATER_Y = 40;
    private static final int ENERGY_X = 126;
    private static final int ENERGY_Y = 39;
    private static final int SOLAR_EFFICIENCY_X = 38;
    private static final int SOLAR_EFFICIENCY_Y = 75;
    private final CableTier tier;
    private final RedstoneControlComponent redstoneControl;
    private final MIInventory inventory;
    private final EnergyComponent energy;
    private final MIEnergyStorage extractable;
    private final SolarSunlightComponent sunlight;
    private final SolarGeneratorComponent generator;

    public SolarPanelMachineBlockEntity(BEP bep, ResourceLocation blockId, CableTier tier) {
        super(bep, new MachineGuiParameters.Builder(blockId, true).backgroundHeight(180).build(), new OrientationComponent.Params(true, false, false));
        this.tier = tier;
        long capacity = 32000L;
        this.redstoneControl = new RedstoneControlComponent();
        List<ConfigurableItemStack> itemStacks = List.of(ConfigurableItemStack.standardInputSlot());
        SlotPositions itemPositions = new SlotPositions.Builder().addSlot(58, 40).build();
        List<ConfigurableFluidStack> fluidStacks = List.of(ConfigurableFluidStack.lockedInputSlot((long)capacity, (Fluid)EIFluids.DISTILLED_WATER.asFluid()));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(38, 40).build();
        this.inventory = new MIInventory(itemStacks, fluidStacks, itemPositions, fluidPositions);
        this.energy = new EnergyComponent((BlockEntity)this, () -> tier.getEu() * 100L);
        this.extractable = this.energy.buildExtractable(otherTier -> otherTier == tier);
        this.sunlight = new SolarSunlightComponent(this);
        this.generator = new SolarGeneratorComponent(this.inventory, this.energy, this::getEfficiency, cell -> cell.getTier() == tier);
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new EnergyBar(new EnergyBar.Params(126, 39), () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(guiComponentServerArray);
        this.registerGuiComponent(new GuiComponentServer[]{new SlotPanel((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl)});
        GuiComponentServer[] guiComponentServerArray2 = new GuiComponentServer[1];
        guiComponentServerArray2[0] = SolarEfficiencyBar.energyProduced(new SolarEfficiencyBar.Params(38, 75), this.sunlight::canOperate, () -> (int)(this.getEfficiency() * 100.0f), this.generator::getEnergyPerTick);
        this.registerGuiComponent(guiComponentServerArray2);
        this.registerComponents(new MachineComponent[]{this.inventory, this.energy, this.redstoneControl, this.sunlight, this.generator});
    }

    public float getEfficiency() {
        return this.sunlight.getSolarEfficiency();
    }

    public MIInventory getInventory() {
        return this.inventory;
    }

    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.tier.casing);
        this.orientation.writeModelData(data);
        return data;
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public void onPlaced(LivingEntity placer, ItemStack itemStack) {
        super.onPlaced(placer, itemStack);
        if (this.orientation.params.hasOutput) {
            this.orientation.outputDirection = Direction.DOWN;
        }
    }

    public boolean useWrench(Player player, InteractionHand hand, BlockHitResult hitResult) {
        Direction face = MachineOverlay.findHitSide((BlockHitResult)hitResult);
        if (face != Direction.UP && this.orientation.useWrench(player, hand, face)) {
            this.level.blockUpdated(this.getBlockPos(), Blocks.AIR);
            this.setChanged();
            if (!this.level.isClientSide()) {
                this.sync();
            }
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (this.sunlight.canOperate() && this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this)) {
            this.generator.tick();
        }
        EnergyHelper.autoOutput((MachineBlockEntity)this, (OrientationComponent)this.orientation, (CableTier)this.tier, (MIEnergyStorage)this.extractable);
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    public List<Component> getTooltips() {
        ArrayList tooltips = Lists.newArrayList();
        tooltips.add(EI.text().solarPanelPhotovoltaicCell());
        tooltips.add(EI.text().solarPanelSunlight());
        tooltips.add(EI.text().solarPanelDistilledWater(EIFluids.DISTILLED_WATER.asFluid()));
        return tooltips;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> direction != Direction.UP ? ((SolarPanelMachineBlockEntity)be).extractable : null));
    }
}

