/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datamap;

import aztech.modern_industrialization.api.energy.CableTier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.swedz.extended_industrialization.EIDataMaps;
import net.swedz.tesseract.neoforge.compat.mi.serialization.MICodecs;
import net.swedz.tesseract.neoforge.helper.RegistryHelper;

public record EnchantmentModule(ResourceKey<Enchantment> enchantment, Value fallback, Map<CableTier, Value> values) {
    public static final Codec<EnchantmentModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.ENCHANTMENT).fieldOf("enchantment").forGetter(EnchantmentModule::enchantment), (App)Value.CODEC.fieldOf("fallback").forGetter(EnchantmentModule::fallback), (App)Codec.unboundedMap((Codec)MICodecs.CABLE_TIER, Value.CODEC).fieldOf("values").forGetter(EnchantmentModule::values)).apply((Applicative)instance, EnchantmentModule::new));

    public EnchantmentModule {
        values = Collections.unmodifiableMap(values);
    }

    public Holder<Enchantment> enchantment(HolderLookup.Provider access) {
        return access.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(this.enchantment);
    }

    public boolean has(CableTier tier) {
        return tier != null && this.values.containsKey(tier);
    }

    public Value get(CableTier tier) {
        return tier == null ? this.fallback : this.values.getOrDefault(tier, this.fallback);
    }

    public int getLevel(CableTier tier) {
        return this.get(tier).level();
    }

    public long getEuCost(CableTier tier) {
        return this.get(tier).euCost();
    }

    public void applyEnchantment(HolderLookup.Provider access, ItemStack stack, CableTier tier) {
        ItemEnchantments currentEnchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (currentEnchantments == null) {
            currentEnchantments = ItemEnchantments.EMPTY;
        }
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(currentEnchantments);
        enchantments.set(this.enchantment(access), this.getLevel(tier));
        stack.set(DataComponents.ENCHANTMENTS, (Object)enchantments.toImmutable());
    }

    public static EnchantmentModule getFor(Item item) {
        return (EnchantmentModule)RegistryHelper.holder((Registry)BuiltInRegistries.ITEM, (Object)item).getData(EIDataMaps.ENCHANTMENT_MODULE);
    }

    public record Value(int level, long euCost) {
        public static final Codec<Value> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)255).fieldOf("level").forGetter(Value::level), (App)Codec.LONG.fieldOf("eu_cost").forGetter(Value::euCost)).apply((Applicative)instance, Value::new));
    }
}

