/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.recipes;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.RecipesServerDatagenProvider;
import net.swedz.extended_industrialization.material.EIMaterials;
import net.swedz.tesseract.neoforge.compat.mi.recipe.MIMachineRecipeBuilder;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapedRecipeBuilder;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapelessRecipeBuilder;

public final class MachineItemRecipesServerDatagenProvider
extends RecipesServerDatagenProvider {
    public MachineItemRecipesServerDatagenProvider(GatherDataEvent event) {
        super(event);
    }

    private static String machine(String machine, String tier) {
        return "%s:%s".formatted("extended_industrialization", tier == null ? machine : "%s_%s".formatted(tier, machine));
    }

    private static String machineBronze(String machine) {
        return MachineItemRecipesServerDatagenProvider.machine(machine, "bronze");
    }

    private static String machineSteel(String machine) {
        return MachineItemRecipesServerDatagenProvider.machine(machine, "steel");
    }

    private static void addBasicCraftingMachineRecipes(String machineName, String machineTier, Consumer<ShapedRecipeBuilder> crafting, boolean assembler, RecipeOutput output) {
        String recipeId = machineTier == null ? "" : "/%s".formatted(machineTier);
        ShapedRecipeBuilder builder = new ShapedRecipeBuilder();
        crafting.accept(builder);
        builder.output(MachineItemRecipesServerDatagenProvider.machine(machineName, machineTier), 1);
        builder.offerTo(output, EI.id("machines/%s/craft%s".formatted(machineName, recipeId)));
        if (assembler) {
            MIMachineRecipeBuilder.fromShapedToAssembler((ShapedRecipeBuilder)builder).offerTo(output, EI.id("machines/%s/assembler%s".formatted(machineName, recipeId)));
        }
    }

    private static void addBasicCraftingMachineRecipes(String machineName, Consumer<ShapedRecipeBuilder> crafting, boolean assembler, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes(machineName, null, crafting, assembler, output);
    }

    private static void addBasicCraftingMachineRecipes(String machineName, String machineTier, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes(machineName, machineTier, crafting, true, output);
    }

    private static void addBasicCraftingMachineRecipes(String machineName, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes(machineName, null, crafting, output);
    }

    private static void addBronzeMachineRecipes(String machine, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes(machine, "bronze", crafting, output);
    }

    private static void addSteelMachineRecipes(String machine, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes(machine, "steel", crafting, output);
    }

    private static void addElectricMachineRecipes(String machine, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes(machine, "electric", crafting, output);
    }

    private static void addSteelUpgradeMachineRecipes(String machine, RecipeOutput output) {
        ShapelessRecipeBuilder builder = new ShapelessRecipeBuilder().with(MachineItemRecipesServerDatagenProvider.machineBronze(machine)).with(new ItemLike[]{MIItem.STEEL_UPGRADE}).output(MachineItemRecipesServerDatagenProvider.machineSteel(machine), 1);
        builder.offerTo(output, EI.id("machines/%s/craft/upgrade_steel".formatted(machine)));
        MIMachineRecipeBuilder.fromShapelessToPacker((ShapelessRecipeBuilder)builder).offerTo(output, EI.id("machines/%s/packer/upgrade_steel".formatted(machine)));
        MIMachineRecipeBuilder.fromShapelessToUnpackerAndFlip((ShapelessRecipeBuilder)builder).offerTo(output, EI.id("machines/%s/unpacker/downgrade_steel".formatted(machine)));
    }

    private static void addBronzeAndSteelMachineRecipes(String machine, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBronzeMachineRecipes(machine, crafting, output);
        MachineItemRecipesServerDatagenProvider.addSteelUpgradeMachineRecipes(machine, output);
    }

    private static void addInterchangeableMachinesRecipes(String machineA, String machineB, RecipeOutput output) {
        String recipeBId = "from_%s".formatted(machineA);
        new ShapelessRecipeBuilder().with(MachineItemRecipesServerDatagenProvider.machine(machineA, null)).output(MachineItemRecipesServerDatagenProvider.machine(machineB, null), 1).offerTo(output, EI.id("machines/%s/craft/%s".formatted(machineB, recipeBId)));
        String recipeAId = "from_%s".formatted(machineB);
        new ShapelessRecipeBuilder().with(MachineItemRecipesServerDatagenProvider.machine(machineB, null)).output(MachineItemRecipesServerDatagenProvider.machine(machineA, null), 1).offerTo(output, EI.id("machines/%s/craft/%s".formatted(machineA, recipeAId)));
    }

    private static void bendingMachine(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBronzeAndSteelMachineRecipes("bending_machine", builder -> builder.define('G', "modern_industrialization:copper_gear").define('R', EITags.itemCommon("rods/copper")).define('C', "modern_industrialization:bronze_machine_casing").define('P', MITags.FLUID_PIPES).pattern("GRG").pattern("RCR").pattern("PPP"), output);
        MachineItemRecipesServerDatagenProvider.addElectricMachineRecipes("bending_machine", builder -> builder.define('A', "modern_industrialization:analog_circuit").define('P', "modern_industrialization:piston").define('M', "modern_industrialization:motor").define('C', "modern_industrialization:basic_machine_hull").define('c', "modern_industrialization:tin_cable").pattern("APA").pattern("MCM").pattern("cPc"), output);
    }

    private static void composter(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBronzeAndSteelMachineRecipes("composter", builder -> builder.define('G', "modern_industrialization:copper_gear").define('O', "modern_industrialization:bronze_barrel").define('R', "modern_industrialization:copper_rotor").define('C', "modern_industrialization:bronze_machine_casing").define('P', MITags.FLUID_PIPES).pattern("GOG").pattern("RCR").pattern("PPP"), output);
        MachineItemRecipesServerDatagenProvider.addElectricMachineRecipes("composter", builder -> builder.define('A', "modern_industrialization:analog_circuit").define('P', MITags.FLUID_PIPES).define('M', "modern_industrialization:motor").define('C', "modern_industrialization:basic_machine_hull").define('c', "modern_industrialization:tin_cable").define('p', "modern_industrialization:pump").pattern("APA").pattern("MCM").pattern("cpc"), output);
    }

    private static void solarBoiler(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBronzeAndSteelMachineRecipes("solar_boiler", builder -> builder.define('G', EITags.itemCommon("glass_blocks")).define('S', EITags.itemCommon("plates/silver")).define('B', "modern_industrialization:fire_clay_bricks").define('C', "modern_industrialization:bronze_boiler").pattern("GGG").pattern("SSS").pattern("BCB"), output);
        MachineItemRecipesServerDatagenProvider.addSteelMachineRecipes("solar_boiler", builder -> builder.define('G', EITags.itemCommon("glass_blocks")).define('S', EITags.itemCommon("plates/silver")).define('B', "modern_industrialization:fire_clay_bricks").define('C', "modern_industrialization:steel_boiler").pattern("GGG").pattern("SSS").pattern("BCB"), output);
    }

    private static void alloySmelter(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addSteelMachineRecipes("alloy_smelter", builder -> builder.define('I', EITags.itemCommon("plates/invar")).define('R', "modern_industrialization:bronze_rotor").define('C', "modern_industrialization:steel_machine_casing").define('P', MITags.FLUID_PIPES).pattern("IRI").pattern("ICI").pattern("PPP"), output);
        MachineItemRecipesServerDatagenProvider.addElectricMachineRecipes("alloy_smelter", builder -> builder.define('W', "modern_industrialization:cupronickel_wire_magnetic").define('R', "modern_industrialization:tin_rotor").define('A', "modern_industrialization:analog_circuit").define('C', "modern_industrialization:basic_machine_hull").define('c', "modern_industrialization:tin_cable").pattern("WRW").pattern("ACA").pattern("cWc"), output);
    }

    private static void canningMachine(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addSteelMachineRecipes("canning_machine", builder -> builder.define('P', MITags.FLUID_PIPES).define('T', "modern_industrialization:steel_tank").define('R', "modern_industrialization:bronze_rotor").define('C', "modern_industrialization:steel_machine_casing").pattern("PTP").pattern("RCR").pattern("PPP"), output);
        MachineItemRecipesServerDatagenProvider.addElectricMachineRecipes("canning_machine", builder -> builder.define('P', MITags.FLUID_PIPES).define('R', "modern_industrialization:tin_rotor").define('p', "modern_industrialization:pump").define('C', "modern_industrialization:basic_machine_hull").define('A', "modern_industrialization:analog_circuit").define('c', "modern_industrialization:conveyor").pattern("PRP").pattern("pCp").pattern("AcA"), output);
    }

    private static void honeyExtractor(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addSteelMachineRecipes("honey_extractor", builder -> builder.define('R', EITags.itemCommon("rods/bronze")).define('r', "modern_industrialization:bronze_rotor").define('T', "modern_industrialization:steel_tank").define('C', "modern_industrialization:steel_machine_casing").define('P', MITags.FLUID_PIPES).pattern("RrR").pattern("TCT").pattern("PPP"), output);
        MachineItemRecipesServerDatagenProvider.addElectricMachineRecipes("honey_extractor", builder -> builder.define('A', "modern_industrialization:analog_circuit").define('R', "modern_industrialization:tin_rotor").define('G', EITags.itemCommon("glass_blocks")).define('C', "modern_industrialization:basic_machine_hull").define('c', "modern_industrialization:tin_cable").define('P', "modern_industrialization:pump").pattern("ARA").pattern("GCG").pattern("cPc"), output);
    }

    private static void farmer(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("farmer", "steam", builder -> builder.define('B', "modern_industrialization:bronze_plated_bricks").define('C', "extended_industrialization:steel_combine").define('A', "modern_industrialization:analog_circuit").define('M', "modern_industrialization:motor").define('P', "modern_industrialization:bronze_machine_casing_pipe").pattern("BCB").pattern("AMA").pattern("BPB"), output);
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("farmer", "electric", builder -> builder.define('A', "modern_industrialization:robot_arm").define('M', "modern_industrialization:large_motor").define('C', "modern_industrialization:steel_machine_casing").define('F', "extended_industrialization:steam_farmer").define('P', "modern_industrialization:large_pump").define('p', "modern_industrialization:steel_machine_casing_pipe").pattern("AMA").pattern("CFC").pattern("PpP"), output);
    }

    private static void brewery(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addSteelMachineRecipes("brewery", builder -> builder.define('R', "modern_industrialization:bronze_rotor").define('T', "modern_industrialization:steel_tank").define('B', "minecraft:blaze_rod").define('C', "modern_industrialization:steel_machine_casing").define('P', MITags.FLUID_PIPES).pattern("RTR").pattern("BCB").pattern("PPP"), output);
        MachineItemRecipesServerDatagenProvider.addElectricMachineRecipes("brewery", builder -> builder.define('R', "modern_industrialization:tin_rotor").define('A', "modern_industrialization:analog_circuit").define('B', "minecraft:blaze_rod").define('C', "modern_industrialization:basic_machine_hull").define('P', "modern_industrialization:pump").pattern("RAR").pattern("BCB").pattern("PAP"), output);
    }

    private static void wasteCollector(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBronzeAndSteelMachineRecipes("waste_collector", builder -> builder.define('B', "minecraft:iron_bars").define('R', "modern_industrialization:copper_rotor").define('C', "modern_industrialization:bronze_machine_casing").define('P', MITags.FLUID_PIPES).pattern("BBB").pattern("RCR").pattern("PPP"), output);
        MachineItemRecipesServerDatagenProvider.addElectricMachineRecipes("waste_collector", builder -> builder.define('B', "minecraft:iron_bars").define('R', "modern_industrialization:tin_rotor").define('C', "modern_industrialization:basic_machine_hull").define('c', "modern_industrialization:tin_cable").define('P', "modern_industrialization:pump").pattern("BBB").pattern("RCR").pattern("cPc"), output);
    }

    private static void processingArray(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("processing_array", builder -> builder.define('A', "modern_industrialization:robot_arm").define('D', "modern_industrialization:digital_circuit").define('C', "modern_industrialization:clean_stainless_steel_machine_casing").define('S', "modern_industrialization:assembler").pattern("ADA").pattern("CSC").pattern("ADA"), output);
    }

    private static void largeFurnace(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("large_steam_furnace", builder -> builder.define('C', "modern_industrialization:bronze_curved_plate").define('B', "modern_industrialization:bronze_plated_bricks").define('F', "modern_industrialization:bronze_furnace").define('M', "modern_industrialization:bronze_machine_casing").define('R', "modern_industrialization:fire_clay_bricks").pattern("CBC").pattern("FMF").pattern("RRR"), output);
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("large_electric_furnace", builder -> builder.define('C', "modern_industrialization:cupronickel_wire_magnetic").define('E', "modern_industrialization:electronic_circuit").define('F', "modern_industrialization:electric_furnace").define('H', "modern_industrialization:advanced_machine_hull").define('I', "modern_industrialization:heatproof_machine_casing").pattern("CEC").pattern("FHF").pattern("IEI"), output);
    }

    private static void largeMacerator(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("large_steam_macerator", builder -> builder.define('C', "modern_industrialization:bronze_curved_plate").define('B', "modern_industrialization:bronze_plated_bricks").define('F', "modern_industrialization:bronze_macerator").define('M', "modern_industrialization:bronze_machine_casing").pattern("CBC").pattern("FMF").pattern("CBC"), output);
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("large_electric_macerator", builder -> builder.define('I', "modern_industrialization:invar_rotary_blade").define('E', "modern_industrialization:electronic_circuit").define('M', "modern_industrialization:electric_macerator").define('H', "modern_industrialization:advanced_machine_hull").define('S', "extended_industrialization:steel_plated_bricks").pattern("IEI").pattern("MHM").pattern("SES"), output);
    }

    private static void universalTransformer(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("universal_transformer", builder -> builder.define('T', "modern_industrialization:tin_cable").define('E', "modern_industrialization:electrum_cable").define('A', "modern_industrialization:aluminum_cable").define('H', "modern_industrialization:basic_machine_hull").pattern("TEA").pattern(" H ").pattern("AET"), output);
    }

    private static void machineChainer(RecipeOutput output) {
        ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.ASSEMBLER, 8, 200).addItemInput((ItemLike)MIBlock.ADVANCED_MACHINE_HULL, 1)).addItemInput((ItemLike)MIItem.LARGE_MOTOR, 2)).addItemInput((ItemLike)MIItem.LARGE_PUMP, 2)).addItemInput(MITags.ITEM_PIPES, 64)).addItemInput(MITags.FLUID_PIPES, 64)).addItemInput("modern_industrialization:electrum_cable", 64)).addItemOutput("extended_industrialization:machine_chainer", 1)).offerTo(output, "machines/machine_chainer/assembler");
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("machine_chainer_relay", builder -> builder.define('P', EITags.itemCommon("plates/iron")).define('I', MITags.ITEM_PIPES).define('C', "modern_industrialization:cupronickel_coil").define('F', MITags.FLUID_PIPES).pattern("PPP").pattern("ICF").pattern("PPP"), output);
    }

    private static void solarPanel(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("lv_solar_panel", builder -> builder.define('R', EITags.itemCommon("rods/tin")).define('C', "modern_industrialization:analog_circuit").define('F', MITags.FLUID_PIPES).define('H', "modern_industrialization:basic_machine_hull").define('c', "modern_industrialization:tin_cable").define('M', "modern_industrialization:motor").pattern("RCR").pattern("FHF").pattern("cMc"), output);
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("mv_solar_panel", builder -> builder.define('R', EITags.itemCommon("rods/aluminum")).define('C', "modern_industrialization:electronic_circuit").define('F', MITags.FLUID_PIPES).define('H', "modern_industrialization:advanced_machine_hull").define('c', "modern_industrialization:electrum_cable").define('M', "modern_industrialization:large_motor").pattern("RCR").pattern("FHF").pattern("cMc"), output);
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("hv_solar_panel", builder -> builder.define('R', EITags.itemCommon("rods/stainless_steel")).define('C', "modern_industrialization:digital_circuit").define('F', MITags.FLUID_PIPES).define('H', "modern_industrialization:turbo_machine_hull").define('c', "modern_industrialization:aluminum_cable").define('M', "modern_industrialization:advanced_motor").pattern("RCR").pattern("FHF").pattern("cMc"), output);
    }

    private static void largeConfigurableChest(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("large_configurable_chest", (ShapedRecipeBuilder builder) -> builder.define('C', "modern_industrialization:configurable_chest").define('c', new ItemLike[]{MIItem.CONVEYOR}).pattern("C").pattern("c").pattern("C"), false, output);
        MachineItemRecipesServerDatagenProvider.addMachineRecipe("machines/large_configurable_chest", "packer", MIMachineRecipeTypes.PACKER, 4, 100, builder -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)builder.addItemInput("modern_industrialization:configurable_chest", 1)).addItemInput((ItemLike)MIItem.CONVEYOR, 1)).addItemInput("modern_industrialization:configurable_chest", 1)).addItemOutput("%s:large_configurable_chest".formatted("extended_industrialization"), 1), output);
    }

    private static void tesla(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("tesla_coil", (ShapedRecipeBuilder builder) -> builder.define('L', new ItemLike[]{EIMaterials.SILVER.get(EIMaterials.Parts.TESLA_TOP_LOAD)}).define('E', new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT}).define('H', "modern_industrialization:advanced_machine_hull").define('B', "modern_industrialization:silicon_battery").define('C', "modern_industrialization:electrum_cable").pattern(" L ").pattern("EHE").pattern("BCB"), true, output);
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("tesla_receiver", (ShapedRecipeBuilder builder) -> builder.define('L', new ItemLike[]{EIMaterials.SILVER.get(EIMaterials.Parts.TESLA_TOP_LOAD)}).define('E', new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT}).define('H', "modern_industrialization:advanced_machine_hull").define('B', "modern_industrialization:silicon_battery").define('C', "modern_industrialization:electrum_cable").pattern(" L ").pattern("BHB").pattern("ECE"), true, output);
        MachineItemRecipesServerDatagenProvider.addInterchangeableMachinesRecipes("tesla_coil", "tesla_receiver", output);
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("lethal_tesla_coil", (ShapedRecipeBuilder builder) -> builder.define('L', new ItemLike[]{EIMaterials.SILVER.get(EIMaterials.Parts.TESLA_TOP_LOAD)}).define('E', new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT}).define('H', "modern_industrialization:advanced_machine_hull").define('B', "modern_industrialization:sodium_battery").define('C', "modern_industrialization:aluminum_cable").define('P', "modern_industrialization:tungsten_plate").pattern("PLP").pattern("CHC").pattern("EBE"), true, output);
        String[] casings = new String[]{"basic", "advanced", "turbo", "highly_advanced", "quantum"};
        String[] cables = new String[]{"tin", "electrum", "aluminum", "annealed_copper", "superconductor"};
        CableTier[] cableTiers = new CableTier[]{CableTier.LV, CableTier.MV, CableTier.HV, CableTier.EV, CableTier.SUPERCONDUCTOR};
        for (int i = 0; i < casings.length; ++i) {
            String casing = casings[i];
            String cable = cables[i];
            CableTier tier = cableTiers[i];
            MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("%s_tesla_receiver_hatch".formatted(tier.name), (ShapedRecipeBuilder builder) -> builder.define('R', "%s:tesla_receiver".formatted("extended_industrialization")).define('H', "%s:%s_machine_hull".formatted("modern_industrialization", casing)).define('C', "%s:%s_cable".formatted("modern_industrialization", cable)).pattern("R").pattern("H").pattern("C"), true, output);
            MachineItemRecipesServerDatagenProvider.addMachineRecipe("machines/%s_tesla_receiver_hatch".formatted(tier.name), "unpacker", MIMachineRecipeTypes.UNPACKER, 2, 200, builder -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)builder.addItemInput("%s:%s_tesla_receiver_hatch".formatted("extended_industrialization", tier.name), 1)).addItemOutput("%s:%s_machine_hull".formatted("modern_industrialization", casing), 1)).addItemOutput("%s:tesla_receiver".formatted("extended_industrialization"), 1), output);
        }
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("tesla_tower", (ShapedRecipeBuilder builder) -> builder.define('A', "modern_industrialization:aluminum_cable").define('C', "modern_industrialization:clean_stainless_steel_machine_casing").define('D', new ItemLike[]{MIItem.DIGITAL_CIRCUIT}).define('H', "modern_industrialization:turbo_machine_hull").pattern("ACA").pattern("DHD").pattern("ACA"), true, output);
    }

    protected void buildRecipes(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.bendingMachine(output);
        MachineItemRecipesServerDatagenProvider.composter(output);
        MachineItemRecipesServerDatagenProvider.solarBoiler(output);
        MachineItemRecipesServerDatagenProvider.alloySmelter(output);
        MachineItemRecipesServerDatagenProvider.canningMachine(output);
        MachineItemRecipesServerDatagenProvider.honeyExtractor(output);
        MachineItemRecipesServerDatagenProvider.farmer(output);
        MachineItemRecipesServerDatagenProvider.brewery(output);
        MachineItemRecipesServerDatagenProvider.wasteCollector(output);
        MachineItemRecipesServerDatagenProvider.processingArray(output);
        MachineItemRecipesServerDatagenProvider.largeFurnace(output);
        MachineItemRecipesServerDatagenProvider.largeMacerator(output);
        MachineItemRecipesServerDatagenProvider.universalTransformer(output);
        MachineItemRecipesServerDatagenProvider.machineChainer(output);
        MachineItemRecipesServerDatagenProvider.solarPanel(output);
        MachineItemRecipesServerDatagenProvider.largeConfigurableChest(output);
        MachineItemRecipesServerDatagenProvider.tesla(output);
    }
}

