/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.model.chainer;

import aztech.modern_industrialization.client.machines.models.MachineBakedModel;
import aztech.modern_industrialization.client.util.ModelHelper;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.swedz.extended_industrialization.client.model.chainer.MachineChainerOverlaysJson;

public final class MachineChainerBakedModel
implements IDynamicBakedModel {
    public static float Z_OFFSET = 5.0E-4f;
    private static final ChunkRenderTypeSet CUTOUT_MIPPED = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutoutMipped()});
    private final MachineCasing casing;
    private final MachineChainerOverlaysJson overlaysJson;
    private final TextureAtlasSprite[] overlays;
    private final MachineModelClientData defaultData;

    MachineChainerBakedModel(MachineCasing casing, MachineChainerOverlaysJson overlaysJson, TextureAtlasSprite[] overlays) {
        this.casing = casing;
        this.overlaysJson = overlaysJson;
        this.overlays = overlays;
        this.defaultData = new MachineModelClientData(casing, Direction.NORTH);
    }

    public TextureAtlasSprite[] getSprites() {
        return this.overlays;
    }

    public static TextureAtlasSprite getSprite(TextureAtlasSprite[] sprites, Direction side, Direction facingDirection, boolean isActive) {
        int spriteId = 1;
        if (side == facingDirection) {
            spriteId = 0;
        } else if (side == facingDirection.getOpposite()) {
            spriteId = 1;
        } else if (side.getAxis().isHorizontal()) {
            if (facingDirection.getAxis().isVertical()) {
                spriteId = facingDirection == Direction.UP ? 2 : 3;
            } else {
                spriteId = switch (facingDirection) {
                    case Direction.NORTH -> {
                        if (side == Direction.WEST) {
                            yield 4;
                        }
                        yield 5;
                    }
                    case Direction.SOUTH -> {
                        if (side == Direction.WEST) {
                            yield 5;
                        }
                        yield 4;
                    }
                    case Direction.WEST -> {
                        if (side == Direction.NORTH) {
                            yield 5;
                        }
                        yield 4;
                    }
                    case Direction.EAST -> {
                        if (side == Direction.NORTH) {
                            yield 4;
                        }
                        yield 5;
                    }
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facingDirection));
                };
            }
        } else if (side.getAxis().isVertical() && facingDirection.getAxis().isHorizontal()) {
            spriteId = switch (facingDirection) {
                case Direction.NORTH -> {
                    if (side == Direction.UP) {
                        yield 2;
                    }
                    yield 3;
                }
                case Direction.SOUTH -> {
                    if (side == Direction.UP) {
                        yield 3;
                    }
                    yield 2;
                }
                case Direction.WEST -> 4;
                case Direction.EAST -> 5;
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facingDirection));
            };
        }
        return sprites[spriteId];
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        MachineModelClientData machineData = (MachineModelClientData)modelData.get(MachineModelClientData.KEY);
        if (machineData == null) {
            return modelData;
        }
        MachineCasing casing = Objects.requireNonNullElse(machineData.casing, this.casing);
        return MachineBakedModel.getCasingModel((MachineCasing)casing).getModelData(level, pos, state, modelData);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        MachineModelClientData data = (MachineModelClientData)extraData.get(MachineModelClientData.KEY);
        if (data == null) {
            data = this.defaultData;
        }
        MachineCasing casing = Objects.requireNonNullElse(data.casing, this.casing);
        TextureAtlasSprite[] sprites = this.getSprites();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        QuadBakingVertexConsumer vc = new QuadBakingVertexConsumer();
        if (side != null) {
            quads.addAll(MachineBakedModel.getCasingModel((MachineCasing)casing).getQuads(state, side, rand, extraData, renderType));
            TextureAtlasSprite sprite = MachineChainerBakedModel.getSprite(sprites, side, data.frontDirection, false);
            if (sprite != null) {
                quads.add(ModelHelper.bakeSprite((QuadBakingVertexConsumer)vc, (Direction)side, (TextureAtlasSprite)sprite, (float)(-Z_OFFSET)));
            }
        }
        if (data.outputDirection != null && side == data.outputDirection) {
            int[] outputIndexes = this.overlaysJson.getOutputSpriteIndexes();
            quads.add(ModelHelper.bakeSprite((QuadBakingVertexConsumer)vc, (Direction)data.outputDirection, (TextureAtlasSprite)sprites[outputIndexes[0]], (float)(-3.0f * Z_OFFSET)));
            if (data.itemAutoExtract) {
                quads.add(ModelHelper.bakeSprite((QuadBakingVertexConsumer)vc, (Direction)data.outputDirection, (TextureAtlasSprite)sprites[outputIndexes[1]], (float)(-3.0f * Z_OFFSET)));
            }
            if (data.fluidAutoExtract) {
                quads.add(ModelHelper.bakeSprite((QuadBakingVertexConsumer)vc, (Direction)data.outputDirection, (TextureAtlasSprite)sprites[outputIndexes[2]], (float)(-3.0f * Z_OFFSET)));
            }
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return MachineBakedModel.getCasingModel((MachineCasing)this.casing).getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return ModelHelper.MODEL_TRANSFORM_BLOCK;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return CUTOUT_MIPPED;
    }
}

