/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.registry;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.RegisterEvent;
import ovh.corail.woodcutter.block.WoodcutterBlock;
import ovh.corail.woodcutter.compatibility.SupportMods;
import ovh.corail.woodcutter.helper.Helper;
import ovh.corail.woodcutter.item.WoodcutterItem;

public class ModBlocks {
    public static final Set<Block> WOODCUTTERS = new HashSet<Block>();
    public static final Set<Item> WOODCUTTER_ITEMS = new HashSet<Item>();
    private static final Random RANDOM = new Random();
    private static ItemStack RANDOM_STACK = ItemStack.EMPTY;

    static void onRegisterBlocks(RegisterEvent event) {
        ModBlocks.registerWoodcutter(event, "", "acacia", "bamboo", "bamboo_mosaic", "birch", "cherry", "crimson", "dark_oak", "jungle", "spruce", "mangrove", "oak", "warped");
        if (SupportMods.BIOMESOPLENTY.isLoaded()) {
            ModBlocks.registerWoodcutter(event, "bop", "dead", "fir", "hellbark", "jacaranda", "magic", "mahogany", "palm", "redwood", "umbran", "willow", "pine", "maple", "empyreal");
        }
    }

    static void onRegisterBlockItems(RegisterEvent event) {
        WOODCUTTERS.forEach(woodcutterBlock -> {
            WoodcutterItem woodcutter = new WoodcutterItem((Block)woodcutterBlock);
            WOODCUTTER_ITEMS.add((Item)woodcutter);
            event.register(Registries.ITEM, Helper.getRegistryRL(woodcutterBlock), () -> ModBlocks.lambda$onRegisterBlockItems$0((Item)woodcutter));
        });
    }

    static void onRegisterBlockTypes(RegisterEvent event) {
        event.register(Registries.BLOCK_TYPE, ResourceLocation.fromNamespaceAndPath((String)"corail_woodcutter", (String)"woodcutter"), () -> WoodcutterBlock.CODEC);
    }

    private static void registerWoodcutter(RegisterEvent event, String folder, String ... names) {
        Function<String, String> funcName = folder.isEmpty() ? name -> name + "_woodcutter" : name -> folder + "_" + name + "_woodcutter";
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).requiresCorrectToolForDrops().strength(3.5f);
        for (String name2 : names) {
            WoodcutterBlock woodcutter = new WoodcutterBlock(properties);
            WOODCUTTERS.add((Block)woodcutter);
            event.register(Registries.BLOCK, ResourceLocation.fromNamespaceAndPath((String)"corail_woodcutter", (String)funcName.apply(name2)), () -> ModBlocks.lambda$registerWoodcutter$5((Block)woodcutter));
        }
    }

    public static ItemStack createRandomStack() {
        if (RANDOM_STACK.isEmpty()) {
            RANDOM_STACK = new ItemStack((ItemLike)WOODCUTTERS.stream().skip(RANDOM.nextInt(WOODCUTTERS.size())).findFirst().orElse(Blocks.STONECUTTER));
        }
        return RANDOM_STACK;
    }

    private static /* synthetic */ Block lambda$registerWoodcutter$5(Block woodcutter) {
        return woodcutter;
    }

    private static /* synthetic */ Item lambda$onRegisterBlockItems$0(Item woodcutter) {
        return woodcutter;
    }
}

