/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import ovh.corail.woodcutter.block.WoodcutterBlock;
import ovh.corail.woodcutter.config.ConfigWoodcutter;
import ovh.corail.woodcutter.helper.Helper;
import ovh.corail.woodcutter.inventory.WoodcutterContainer;
import ovh.corail.woodcutter.registry.ModBlocks;

@EventBusSubscriber(modid="corail_woodcutter", bus=EventBusSubscriber.Bus.GAME)
public class WoodcutterItem
extends BlockItem {
    private static final Component DEFAULT_DESCRIPTION = Component.translatable((String)"item.corail_woodcutter.woodcutter.desc").withStyle(ChatFormatting.GRAY);
    private static final Component ACCESS_FROM_INVENTORY = Component.translatable((String)"item.corail_woodcutter.woodcutter.inventory").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});

    public WoodcutterItem(Block woodcutterBlock) {
        super(woodcutterBlock, new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag flagIn) {
        list.add(DEFAULT_DESCRIPTION);
        if (((Boolean)ConfigWoodcutter.general.openWoodcutterInInventory.get()).booleanValue()) {
            list.add(ACCESS_FROM_INVENTORY);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (((Boolean)ConfigWoodcutter.general.openWoodcutterInInventory.get()).booleanValue() && hand == InteractionHand.MAIN_HAND && player.isDiscrete()) {
            ItemStack heldItem = player.getItemInHand(hand);
            if (!world.isClientSide()) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, p) -> new WoodcutterContainer(id, playerInventory), WoodcutterBlock.TRANSLATION));
            }
            return InteractionResultHolder.success((Object)heldItem);
        }
        return super.use(world, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (Helper.isValidPlayer(context.getPlayer()) && context.getHand() == InteractionHand.MAIN_HAND && context.getPlayer().isDiscrete()) {
            return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
        }
        return super.useOn(context);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack;
        if (((Boolean)ConfigWoodcutter.general.openWoodcutterInInventory.get()).booleanValue() && Helper.isValidPlayer(event.getEntity()) && event.getEntity().isDiscrete() && ModBlocks.WOODCUTTER_ITEMS.contains((heldStack = event.getEntity().getItemInHand(event.getHand())).getItem())) {
            event.setCancellationResult(InteractionResult.PASS);
            event.setCanceled(true);
        }
    }
}

