/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.woodcutter.helper.Helper;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;
import ovh.corail.woodcutter.registry.ModBlocks;
import ovh.corail.woodcutter.registry.ModMenuTypes;
import ovh.corail.woodcutter.registry.ModRecipeTypes;

public class WoodcutterContainer
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private final Level level;
    private List<RecipeHolder<WoodcuttingRecipe>> recipes = new ArrayList<RecipeHolder<WoodcuttingRecipe>>();
    private ItemStack input = ItemStack.EMPTY;
    private long lastSoundTime;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private Runnable slotUpdateListener = () -> {};
    private final Container inputInventory = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            WoodcutterContainer.this.slotsChanged((Container)this);
            WoodcutterContainer.this.slotUpdateListener.run();
        }
    };
    private final ResultContainer resultContainer = new ResultContainer();

    public WoodcutterContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.NULL);
    }

    public WoodcutterContainer(int id, Inventory playerInventory, final ContainerLevelAccess access) {
        super(ModMenuTypes.WOODCUTTER, id);
        this.access = access;
        this.level = playerInventory.player.level();
        this.inputSlot = this.addSlot(new Slot(this.inputInventory, 0, 20, 33));
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player playerIn, ItemStack stack) {
                stack.onCraftedBy(playerIn.level(), playerIn, stack.getCount());
                WoodcutterContainer.this.resultContainer.awardUsedRecipes(playerIn, this.getRelevantItems());
                ItemStack itemstack = WoodcutterContainer.this.inputSlot.remove(1);
                if (!itemstack.isEmpty()) {
                    WoodcutterContainer.this.setupResultSlot();
                }
                access.execute((world, pos) -> {
                    long l = world.getGameTime();
                    if (WoodcutterContainer.this.lastSoundTime != l) {
                        world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        WoodcutterContainer.this.lastSoundTime = l;
                    }
                });
                super.onTake(playerIn, stack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(WoodcutterContainer.this.inputSlot.getItem());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlot(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public List<RecipeHolder<WoodcuttingRecipe>> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipes.isEmpty();
    }

    public boolean stillValid(Player playerIn) {
        return (Boolean)this.access.evaluate((world, pos) -> ModBlocks.WOODCUTTERS.contains(world.getBlockState(pos).getBlock()) && playerIn.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    public boolean clickMenuButton(Player playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.set(id);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int id) {
        return id >= 0 && id < this.recipes.size();
    }

    public void slotsChanged(Container inventoryIn) {
        ItemStack stack = this.inputSlot.getItem();
        if (stack.getItem() != this.input.getItem()) {
            this.input = stack.copy();
            this.setupRecipeList(inventoryIn, stack);
        }
    }

    private void setupRecipeList(Container inventoryIn, ItemStack stack) {
        this.selectedRecipeIndex.set(-1);
        this.resultSlot.set(ItemStack.EMPTY);
        this.recipes = stack.isEmpty() ? Collections.emptyList() : Helper.getSortedMatchingRecipes(this.level, inventoryIn);
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            RecipeHolder<WoodcuttingRecipe> recipeHolder = this.recipes.get(this.selectedRecipeIndex.get());
            ItemStack stack = ((WoodcuttingRecipe)recipeHolder.value()).assemble(new SingleRecipeInput(this.inputInventory.getItem(0)), (HolderLookup.Provider)this.level.registryAccess());
            if (stack.isItemEnabled(this.level.enabledFeatures())) {
                this.resultContainer.setRecipeUsed(recipeHolder);
                this.resultSlot.set(stack);
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public MenuType<?> getType() {
        return ModMenuTypes.WOODCUTTER;
    }

    public void registerUpdateListener(Runnable runnable) {
        this.slotUpdateListener = runnable;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.resultContainer && super.canTakeItemForPickAll(stack, slotIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            Item item = itemstack1.getItem();
            stack = itemstack1.copy();
            if (index == 1) {
                item.onCraftedBy(itemstack1, playerIn.level(), playerIn);
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, stack);
            } else if (index == 0 ? !this.moveItemStackTo(itemstack1, 2, 38, false) : (this.level.getRecipeManager().getRecipeFor(ModRecipeTypes.WOODCUTTING, (RecipeInput)new SingleRecipeInput(itemstack1), this.level).isPresent() ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (index < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : index < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
            this.broadcastChanges();
        }
        return stack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (this.access == ContainerLevelAccess.NULL) {
            ItemStack leftStack = this.inputInventory.removeItemNoUpdate(0);
            if (!leftStack.isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)leftStack);
            }
        } else {
            this.access.execute((world, pos) -> this.clearContainer(playerIn, this.inputInventory));
        }
        this.resultContainer.removeItemNoUpdate(0);
    }
}

