/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.client.gui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.woodcutter.inventory.WoodcutterContainer;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;

@OnlyIn(value=Dist.CLIENT)
public class WoodcutterScreen
extends AbstractContainerScreen<WoodcutterContainer> {
    private static final ResourceLocation BG_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/stonecutter.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller_disabled");
    private static final ResourceLocation RECIPE_SELECTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe_selected");
    private static final ResourceLocation RECIPE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe_highlighted");
    private static final ResourceLocation RECIPE_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public WoodcutterScreen(WoodcutterContainer containerIn, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)containerIn, playerInv, title);
        containerIn.registerUpdateListener(this::containerChanged);
        --this.titleLabelY;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(BG_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)(41.0f * this.scrollOffs);
        guiGraphics.blitSprite(this.isScrollBarActive() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE, i + 119, j + 15 + k, 12, 15);
        int l = this.leftPos + 52;
        int i1 = this.topPos + 14;
        int j1 = this.startIndex + 12;
        this.renderButtons(guiGraphics, mouseX, mouseY, l, i1, j1);
        this.renderRecipes(guiGraphics, l, i1, j1);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        if (this.displayRecipes) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.startIndex + 12;
            List<RecipeHolder<WoodcuttingRecipe>> list = ((WoodcutterContainer)this.menu).getRecipes();
            for (int l = this.startIndex; l < k && l < ((WoodcutterContainer)this.menu).getNumRecipes(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                assert (this.minecraft != null && this.minecraft.level != null);
                guiGraphics.renderTooltip(this.font, ((WoodcuttingRecipe)list.get(l).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), x, y);
            }
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int scrollOffset) {
        for (int i = this.startIndex; i < scrollOffset && i < ((WoodcutterContainer)this.menu).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            ResourceLocation rl = i == ((WoodcutterContainer)this.menu).getSelectedRecipeIndex() ? RECIPE_SELECTED_SPRITE : (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18 ? RECIPE_HIGHLIGHTED_SPRITE : RECIPE_SPRITE);
            guiGraphics.blitSprite(rl, k, i1 - 1, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int x, int y, int scrollOffset) {
        List<RecipeHolder<WoodcuttingRecipe>> list = ((WoodcutterContainer)this.menu).getRecipes();
        for (int i = this.startIndex; i < scrollOffset && i < ((WoodcutterContainer)this.menu).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            assert (this.minecraft != null && this.minecraft.level != null);
            guiGraphics.renderItem(((WoodcuttingRecipe)list.get(i).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), k, i1);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int buttonId) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                assert (this.minecraft != null && this.minecraft.player != null);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((WoodcutterContainer)this.menu).clickMenuButton((Player)this.minecraft.player, l)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                assert (this.minecraft.gameMode != null);
                this.minecraft.gameMode.handleInventoryButtonClick(((WoodcutterContainer)this.menu).containerId, l);
                return true;
            }
            i = this.leftPos + 119;
            j = this.topPos + 14;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.scrolling = true;
                this.scrollOffs = Mth.clamp((float)((float)(mouseY - (double)j - 7.5) / 40.0f), (float)0.0f, (float)1.0f);
                this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            }
        }
        return super.mouseClicked(mouseX, mouseY, buttonId);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int buttonId, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 14;
            int j = i + 54;
            this.scrollOffs = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, buttonId, dragX, dragY);
    }

    public boolean mouseScrolled(double p_99314_, double p_99315_, double p_99316_, double p_297300_) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)p_297300_ / (float)i;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((WoodcutterContainer)this.menu).getNumRecipes() > 12;
    }

    private int getOffscreenRows() {
        return (((WoodcutterContainer)this.menu).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((WoodcutterContainer)this.menu).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }

    protected void slotClicked(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (!(type != ClickType.PICKUP || slotId != 0 || mouseButton != 0 || slotIn == null || slotIn.index != 0 || ((WoodcutterContainer)this.menu).getCarried().isEmpty() || slotIn.getItem().isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)((WoodcutterContainer)this.menu).getCarried(), (ItemStack)slotIn.getItem()))) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        super.slotClicked(slotIn, slotId, mouseButton, type);
    }
}

