/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.block;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import ovh.corail.woodcutter.inventory.WoodcutterContainer;
import ovh.corail.woodcutter.registry.ModStats;

public class WoodcutterBlock
extends HorizontalDirectionalBlock
implements BucketPickup,
LiquidBlockContainer {
    public static final MapCodec<WoodcutterBlock> CODEC = WoodcutterBlock.simpleCodec(WoodcutterBlock::new);
    public static final Component TRANSLATION = Component.translatable((String)"container.corail_woodcutter.woodcutter");
    private static final EnumMap<Direction, VoxelShape> SHAPE_BY_DIRECTION = new EnumMap(Direction.class);
    protected static final double[][] BOUNDS = new double[][]{{0.0, 0.5, 0.1875, 1.0, 0.5625, 0.8125}, {0.125, 0.0, 0.3125, 0.1875, 0.5, 0.375}, {0.125, 0.0, 0.625, 0.1875, 0.5, 0.6875}, {0.8125, 0.0, 0.625, 0.875, 0.5, 0.6875}, {0.8125, 0.0, 0.3125, 0.875, 0.5, 0.375}, {0.1875, 0.3125, 0.625, 0.8125, 0.375, 0.6875}, {0.1875, 0.3125, 0.3125, 0.8125, 0.375, 0.375}};

    public WoodcutterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.getBlock() != this && state.getFluidState().getType() == Fluids.WATER));
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (!worldIn.isClientSide) {
            player.openMenu(state.getMenuProvider(worldIn, pos));
            player.awardStat(ModStats.INTERACT_WITH_SAWMILL);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        return new SimpleMenuProvider((id, playerInventory, player) -> new WoodcutterContainer(id, playerInventory, ContainerLevelAccess.create((Level)worldIn, (BlockPos)pos)), TRANSLATION);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_DIRECTION.computeIfAbsent((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), direction -> Arrays.stream(BOUNDS).map(b -> this.createShapeForDirection((double[])b, (Direction)direction)).reduce(Shapes.empty(), Shapes::or));
    }

    private VoxelShape createShapeForDirection(double[] bounds, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> Shapes.box((double)bounds[0], (double)bounds[1], (double)(1.0 - bounds[5]), (double)bounds[3], (double)bounds[4], (double)(1.0 - bounds[2]));
            case Direction.WEST -> Shapes.box((double)bounds[2], (double)bounds[1], (double)bounds[0], (double)bounds[5], (double)bounds[4], (double)bounds[3]);
            case Direction.EAST -> Shapes.box((double)(1.0 - bounds[5]), (double)bounds[1], (double)bounds[0], (double)(1.0 - bounds[2]), (double)bounds[4], (double)bounds[3]);
            default -> Shapes.box((double)bounds[0], (double)bounds[1], (double)bounds[2], (double)bounds[3], (double)bounds[4], (double)bounds[5]);
        };
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED});
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        drops.add(new ItemStack((ItemLike)this));
        return drops;
    }

    public BlockState updateShape(BlockState olState, Direction facing, BlockState newState, LevelAccessor levelAccessor, BlockPos oldPos, BlockPos newPos) {
        if (((Boolean)olState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(oldPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(olState, facing, newState, levelAccessor, oldPos, newPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            levelAccessor.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && fluid == Fluids.WATER;
    }

    public boolean placeLiquid(LevelAccessor levelAccessor, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            if (!levelAccessor.isClientSide()) {
                levelAccessor.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                levelAccessor.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)levelAccessor));
            }
            return true;
        }
        return false;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    protected MapCodec<WoodcutterBlock> codec() {
        return CODEC;
    }
}

