/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.buriedwrecks.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.buriedwrecks.config.BuriedConfig;
import com.mrbysco.buriedwrecks.registry.ModStructureTypes;
import com.mrbysco.buriedwrecks.structure.BuriedShipwreckPieces;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class BuriedWreckFeature
extends Structure {
    public static final MapCodec<BuriedWreckFeature> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BuriedWreckFeature.settingsCodec((RecordCodecBuilder.Instance)builder), (App)Codec.BOOL.fieldOf("is_beached").forGetter(feature -> feature.isBeached), (App)Codec.INT.fieldOf("y_level").forGetter(feature -> feature.yLevel)).apply((Applicative)builder, BuriedWreckFeature::new));
    public final boolean isBeached;
    public final int yLevel;

    public BuriedWreckFeature(Structure.StructureSettings structureSettings, boolean beached, int yLevel) {
        super(structureSettings);
        this.isBeached = beached;
        this.yLevel = yLevel;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext generationContext) {
        return BuriedWreckFeature.onTopOfChunkCenter((Structure.GenerationContext)generationContext, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, piecesBuilder -> this.generatePieces((StructurePiecesBuilder)piecesBuilder, generationContext));
    }

    private void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext generationContext) {
        Rotation rotation = Rotation.getRandom((RandomSource)generationContext.random());
        int yLevel = (Boolean)BuriedConfig.COMMON.overwriteYLevel.get() != false ? (Integer)BuriedConfig.COMMON.yLevel.get() : this.yLevel;
        BlockPos blockpos = new BlockPos(generationContext.chunkPos().getMinBlockX(), yLevel, generationContext.chunkPos().getMinBlockZ());
        BuriedShipwreckPieces.addPieces(generationContext.structureTemplateManager(), blockpos, rotation, (StructurePieceAccessor)piecesBuilder, (RandomSource)generationContext.random(), this.isBeached);
    }

    public GenerationStep.Decoration step() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public StructureType<?> type() {
        return ModStructureTypes.BURIED_SHIPWRECK.get();
    }
}

