/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.core.platform;

import java.util.ServiceLoader;
import net.azurune.runiclib.RunicLib;
import net.azurune.runiclib.core.platform.services.RLClientHelper;
import net.azurune.runiclib.core.platform.services.RLNetworkHelper;
import net.azurune.runiclib.core.platform.services.RLPlatformHelper;
import net.azurune.runiclib.core.platform.services.RLRegistryHelper;

public class RLServices {
    public static final RLPlatformHelper PLATFORM = RLServices.load(RLPlatformHelper.class);
    public static final RLRegistryHelper REGISTRY = RLServices.load(RLRegistryHelper.class);
    public static final RLNetworkHelper NETWORK = RLServices.load(RLNetworkHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        RunicLib.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static RLClientHelper loadClient() {
        if (!PLATFORM.isClient()) {
            throw new IllegalStateException("Client helper requested on server!");
        }
        return RLServices.load(RLClientHelper.class);
    }
}

