/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.core.mixin.server;

import java.util.Random;
import net.azurune.runiclib.core.register.RLAttributes;
import net.azurune.runiclib.core.register.RLMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerMixin {
    Player player = (Player)this;
    private static Random random = new Random();

    @Inject(at={@At(value="TAIL")}, method={"attack"})
    public void runiclib$attack(Entity target, CallbackInfo ci) {
        float amount = (float)this.player.getAttributeValue(Attributes.ATTACK_DAMAGE);
        DamageSource source = this.player.damageSources().playerAttack(this.player);
        double lifestealAmount = this.player.getAttributeValue(RLAttributes.LIFESTEAL_HEAL_AMOUNT);
        double lifestealChance = this.player.getAttributeValue(RLAttributes.LIFESTEAL_CHANCE);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (lifestealChance != 0.0 && random.nextDouble(100.0) < lifestealChance && this.player.isAlive()) {
                this.player.heal((float)lifestealAmount);
                this.player.level().playSound(null, this.player.getX(), this.player.getY(), this.player.getZ(), (Holder)SoundEvents.SOUL_ESCAPE, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            double criticalStrikeChance = this.player.getAttributeValue(RLAttributes.CRITICAL_STRIKE_CHANCE);
            float criticalStrikeMultiplier = (float)this.player.getAttributeValue(RLAttributes.CRITICAL_STRIKE_MULTIPLIER);
            if (criticalStrikeChance != 0.0 && random.nextDouble(100.0) < criticalStrikeChance && this.player.isAlive()) {
                livingEntity.hurt(source, amount * criticalStrikeMultiplier);
                this.player.playSound(SoundEvents.ARROW_HIT_PLAYER, 1.0f, 1.0f);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isHurt"}, cancellable=true)
    public void runiclib$isHurt(CallbackInfoReturnable<Boolean> cir) {
        if (this.player.hasEffect(RLMobEffects.BLOOD_CLOT)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isReducedDebugInfo"}, cancellable=true)
    public void runiclib$hasReducedDebugInfo(CallbackInfoReturnable<Boolean> cir) {
        if (this.player.hasEffect(RLMobEffects.CONFUSION)) {
            cir.setReturnValue((Object)true);
        }
    }
}

