/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.core.library.runiconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class Runiconfig {
    private static final Map<String, Config<?>> CONFIGS = new HashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path configDirectory = Path.of("config", new String[0]);

    public static <T> void registerConfig(String modid, Class<T> configClass, Supplier<T> defaultSupplier) {
        if (CONFIGS.containsKey(modid)) {
            throw new IllegalArgumentException("Config already registered for mod: " + modid);
        }
        try {
            Files.createDirectories(configDirectory, new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to create config directory", exception);
        }
        Path configFile = configDirectory.resolve(modid + ".json");
        T config = Runiconfig.loadConfigFile(configFile, configClass, defaultSupplier.get());
        CONFIGS.put(modid, new Config<T>(configFile, config));
        Runiconfig.saveConfig(modid);
    }

    public static <T> T getConfig(String modid) {
        if (!CONFIGS.containsKey(modid)) {
            throw new IllegalArgumentException("No config registered for mod: " + modid);
        }
        return Runiconfig.CONFIGS.get((Object)modid).config;
    }

    public static void saveConfig(String modid) {
        if (!CONFIGS.containsKey(modid)) {
            throw new IllegalArgumentException("No config registered for mod: " + modid);
        }
        Config<?> config = CONFIGS.get(modid);
        try (BufferedWriter writer = Files.newBufferedWriter(config.path, new OpenOption[0]);){
            GSON.toJson(config.config, (Appendable)writer);
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to save config for mod: " + modid, exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T loadConfigFile(Path path, Class<T> clazz, T defaultConfig) {
        if (!Files.exists(path, new LinkOption[0])) {
            Runiconfig.saveConfigFile(path, defaultConfig);
            return defaultConfig;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Object loaded = GSON.fromJson((Reader)reader, clazz);
            Object object = loaded != null ? loaded : defaultConfig;
            return (T)object;
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to load config file: " + String.valueOf(path), exception);
        }
    }

    private static <T> void saveConfigFile(Path path, T config) {
        try {
            Files.createDirectories(configDirectory, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                GSON.toJson(config, (Appendable)writer);
            }
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to save config file: " + String.valueOf(path), exception);
        }
    }

    private record Config<T>(Path path, T config) {
    }
}

