/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class SetNameCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setname_rl").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(SetNameCommand::execute))));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity targetEntity = EntityArgument.getEntity(ctx, (String)"target");
        String newName = StringArgumentType.getString(ctx, (String)"name");
        targetEntity.setCustomName((Component)Component.literal((String)newName));
        if (targetEntity instanceof Mob) {
            Mob targetMob = (Mob)targetEntity;
            targetMob.setPersistenceRequired();
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runiclib.commands.setname.success", (Object[])new Object[]{targetEntity.getDisplayName(), newName}), true);
        return 1;
    }
}

