/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PurifyCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"purify_rl").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"clearEffects", (ArgumentType)BoolArgumentType.bool()).executes(PurifyCommand::execute))));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity targetEntity = EntityArgument.getEntity(ctx, (String)"target");
        boolean clearEffects = BoolArgumentType.getBool(ctx, (String)"clearEffects");
        if (targetEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)targetEntity;
            living.extinguishFire();
            if (living.isFreezing()) {
                living.setTicksFrozen(0);
            }
            if (clearEffects) {
                living.removeAllEffects();
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runiclib.commands.purify.success", (Object[])new Object[]{living.getDisplayName()}), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"runiclib.commands.not_living"));
        return 0;
    }
}

