/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class KingmeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kingme_rl").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(KingmeCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity targetEntity = EntityArgument.getEntity(ctx, (String)"target");
        if (targetEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)targetEntity;
            player.setHealth(player.getMaxHealth());
            player.getFoodData().setFoodLevel(20);
            player.getFoodData().setSaturation(5.0f);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runiclib.commands.kingme.success", (Object[])new Object[]{player.getDisplayName()}), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"runiclib.commands.not_player"));
        return 0;
    }
}

