/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class HealCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"heal_rl").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(HealCommand::execute))));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity targetEntity = EntityArgument.getEntity(ctx, (String)"target");
        if (targetEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)targetEntity;
            float currentHealth = living.getHealth();
            float amount = Math.max(0.0f, FloatArgumentType.getFloat(ctx, (String)"amount"));
            float result = Math.max(0.0f, Math.min(living.getMaxHealth(), currentHealth + amount));
            if (result == currentHealth) {
                throw new SimpleCommandExceptionType((Message)Component.translatable((String)"runiclib.commands.heal.fail")).create();
            }
            living.setHealth(result);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runiclib.commands.heal.success", (Object[])new Object[]{Float.valueOf(amount), living.getDisplayName()}), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"runiclib.commands.not_living"));
        return 0;
    }
}

