/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.world;

import com.phantomwing.rusticdelight.block.ModBlocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class ModConfiguredFeatures {
    public static ResourceKey<ConfiguredFeature<?, ?>> WILD_COTTON_KEY = ModConfiguredFeatures.registerKey("wild_cotton");
    public static ResourceKey<ConfiguredFeature<?, ?>> WILD_BELL_PEPPERS_KEY = ModConfiguredFeatures.registerKey("wild_bell_peppers");
    public static ResourceKey<ConfiguredFeature<?, ?>> WILD_COFFEE_KEY = ModConfiguredFeatures.registerKey("wild_coffee");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        ModConfiguredFeatures.registerWildCrops(context);
    }

    private static void registerWildCrops(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        ModConfiguredFeatures.registerFlowerPatch(context, WILD_COTTON_KEY, (Block)ModBlocks.WILD_COTTON.get(), 32, 6, 4);
        ModConfiguredFeatures.registerFlowerPatch(context, WILD_BELL_PEPPERS_KEY, (Block)ModBlocks.WILD_BELL_PEPPERS.get(), 48, 4, 4);
        ModConfiguredFeatures.registerFlowerPatch(context, WILD_COFFEE_KEY, (Block)ModBlocks.WILD_COFFEE.get(), 48, 6, 4);
    }

    private static void registerFlowerPatch(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Block block, int tries, int xzSpread, int ySpread) {
        ModConfiguredFeatures.register(context, key, Feature.FLOWER, new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)block)))));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rusticdelight", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

