/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.menu.ServerInputState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.util.function.Predicate;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public abstract class AbstractComputerMenu
extends AbstractContainerMenu
implements ComputerMenu {
    public static final int SIDEBAR_WIDTH = 17;
    private final int uploadMaxSize;
    private final Predicate<Player> canUse;
    private final ComputerFamily family;
    private final ContainerData data;
    private final @Nullable ServerComputer computer;
    private final @Nullable ServerInputState input;
    private final @Nullable NetworkedTerminal terminal;
    private final ItemStack displayStack;

    public AbstractComputerMenu(MenuType<? extends AbstractComputerMenu> type, int id, Predicate<Player> canUse, ComputerFamily family, @Nullable ServerComputer computer, @Nullable ComputerContainerData containerData) {
        super(type, id);
        this.canUse = canUse;
        this.family = family;
        this.data = computer == null ? new SimpleContainerData(1) : () -> computer.isOn() ? 1 : 0;
        this.addDataSlots(this.data);
        this.computer = computer;
        this.input = computer == null ? null : new ServerInputState(this, computer);
        this.terminal = containerData == null ? null : containerData.terminal().create();
        this.displayStack = containerData == null ? ItemStack.EMPTY : containerData.displayStack();
        this.uploadMaxSize = containerData == null ? Config.uploadMaxSize : containerData.uploadMaxSize();
    }

    public boolean stillValid(Player player) {
        return (this.computer == null || this.computer.checkUsable(player)) && this.canUse.test(player);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public boolean isOn() {
        return this.data.get(0) != 0;
    }

    public int getUploadMaxSize() {
        return this.uploadMaxSize;
    }

    @Override
    public ServerComputer getComputer() {
        if (this.computer == null) {
            throw new UnsupportedOperationException("Cannot access server computer on the client");
        }
        return this.computer;
    }

    @Override
    public ServerInputHandler getInput() {
        if (this.input == null) {
            throw new UnsupportedOperationException("Cannot access server computer on the client");
        }
        return this.input;
    }

    @Override
    public void updateTerminal(TerminalState state) {
        if (this.terminal == null) {
            throw new UnsupportedOperationException("Cannot update terminal on the server");
        }
        state.apply(this.terminal);
    }

    public Terminal getTerminal() {
        if (this.terminal == null) {
            throw new IllegalStateException("Cannot update terminal on the server");
        }
        return this.terminal;
    }

    public void removed(Player player) {
        super.removed(player);
        if (this.input != null) {
            this.input.close();
        }
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }
}

