/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.common;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.util.ColourTracker;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.DataComponentUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public final class ColourableRecipe
extends CustomRecipe {
    public ColourableRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level world) {
        boolean hasColourable = false;
        boolean hasDye = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(ComputerCraftTags.Items.DYEABLE)) {
                if (hasColourable) {
                    return false;
                }
                hasColourable = true;
                continue;
            }
            if (ColourUtils.getStackColour(stack) != null) {
                hasDye = true;
                continue;
            }
            return false;
        }
        return hasColourable && hasDye;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        ItemStack colourable = ItemStack.EMPTY;
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(ComputerCraftTags.Items.DYEABLE)) {
                colourable = stack;
                continue;
            }
            DyeColor dye = ColourUtils.getStackColour(stack);
            if (dye == null) continue;
            tracker.addColour(dye);
        }
        return colourable.isEmpty() ? ItemStack.EMPTY : DataComponentUtil.createResult(colourable, DataComponents.DYED_COLOR, new DyedItemColor(tracker.getColour(), false));
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x >= 2 && y >= 2;
    }

    public RecipeSerializer<ColourableRecipe> getSerializer() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.DYEABLE_ITEM.get();
    }
}

