/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dan200.computercraft.client.ClientHooks;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockRenderDispatcher.class})
public class BlockRenderDispatcherMixin {
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    @Final
    private BlockModelShaper blockModelShaper;
    @Shadow
    @Final
    private ModelBlockRenderer modelRenderer;

    @Inject(method={"name=/^renderBreakingTexture/ desc=/ModelData;\\)V$/"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void renderBlockDamage(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack pose, VertexConsumer buffers, ModelData modelData, CallbackInfo info) {
        BlockState newState = ClientHooks.getBlockBreakingState(state, pos);
        if (newState != null) {
            info.cancel();
            BakedModel model = this.blockModelShaper.getBlockModel(newState);
            this.modelRenderer.tesselateBlock(world, model, newState, pos, pose, buffers, true, this.random, newState.getSeed(pos), OverlayTexture.NO_OVERLAY, modelData, null);
        }
    }
}

