/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.events;

import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.config.NetherDepthsUpgradeConfig;
import com.scouter.netherdepthsupgrade.datacomponents.NDUDataComponents;
import com.scouter.netherdepthsupgrade.enchantments.NDUEnchantments;
import com.scouter.netherdepthsupgrade.entity.NDUEntity;
import com.scouter.netherdepthsupgrade.entity.entities.LavaFishingBobberEntity;
import com.scouter.netherdepthsupgrade.items.NDUItems;
import com.scouter.netherdepthsupgrade.potion.NDUPotions;
import java.util.Collection;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;

@EventBusSubscriber(modid="netherdepthsupgrade", bus=EventBusSubscriber.Bus.GAME)
public class ForgeEvents {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        ForgeEvents.addMixes(event.getBuilder());
    }

    public static void addMixes(PotionBrewing.Builder builder) {
        builder.addMix(Potions.AWKWARD, (Item)NDUItems.LAVA_PUFFERFISH.get(), NDUPotions.WITHER.getDelegate());
        builder.addMix(Potions.AWKWARD, (Item)NDUItems.EYEBALL_FISH_EYE.get(), NDUPotions.LAVA_VISION.getDelegate());
        builder.addMix(Potions.AWKWARD, (Item)NDUItems.EYEBALL_FISH.get(), NDUPotions.LAVA_VISION.getDelegate());
        builder.addMix(Potions.AWKWARD, (Item)NDUItems.OBSIDIANFISH.get(), NDUPotions.RESISTANCE.getDelegate());
        builder.addMix(Potions.AWKWARD, (Item)NDUItems.GLOWDINE.get(), NDUPotions.GLOWING.getDelegate());
        builder.addMix(NDUPotions.GLOWING.getDelegate(), Items.REDSTONE, NDUPotions.LONG_GLOWING.getDelegate());
        builder.addMix(NDUPotions.RESISTANCE.getDelegate(), Items.REDSTONE, NDUPotions.LONG_RESISTANCE.getDelegate());
        builder.addMix(NDUPotions.RESISTANCE.getDelegate(), Items.GLOWSTONE_DUST, NDUPotions.STRONG_RESISTANCE.getDelegate());
        builder.addMix(Potions.AWKWARD, (Item)NDUItems.LAVA_PUFFERFISH.get(), NDUPotions.WITHER.getDelegate());
        builder.addMix(NDUPotions.LAVA_VISION.getDelegate(), Items.REDSTONE, NDUPotions.LONG_LAVA_VISION.getDelegate());
    }

    @SubscribeEvent
    public static void lavaMovementSpeed(PlayerTickEvent.Post event) {
        boolean flag;
        if (event.getEntity() == null || event.getEntity().isCreative() || event.getEntity().isSpectator()) {
            return;
        }
        double d0 = 0.0;
        boolean bl = flag = event.getEntity().getDeltaMovement().y <= 0.0;
        if (flag && event.getEntity().hasEffect(MobEffects.SLOW_FALLING)) {
            d0 = 0.01;
        }
        if (EnchantmentHelper.has((ItemStack)event.getEntity().getItemBySlot(EquipmentSlot.FEET), (DataComponentType)((DataComponentType)NDUDataComponents.HAS_HELL_STRIDER.get()))) {
            Player player = event.getEntity();
            int level = ForgeEvents.getHellStriderLevel(player);
            BlockPos eyePos = new BlockPos((int)player.getEyePosition().x(), (int)player.getEyePosition().y(), (int)player.getEyePosition().z());
            FluidState state = player.level().getFluidState(eyePos);
            if (player.isInLava() && player.isAffectedByFluids() && state.is(FluidTags.LAVA)) {
                double e = player.getY();
                float speed = (float)(1.15 + 0.35 * (double)level);
                player.setDeltaMovement(player.getDeltaMovement().multiply((double)speed, (double)0.8f, (double)speed));
                Vec3 vec33 = player.getFluidFallingAdjustedMovement(d0, flag, player.getDeltaMovement());
                player.setDeltaMovement(vec33);
                if (player.isShiftKeyDown()) {
                    player.setDeltaMovement(vec33.x, -0.0750000011920929 * (double)level, vec33.z);
                }
                if (player.horizontalCollision && player.isFree(vec33.x, vec33.y + (double)0.6f - player.getY() + e, vec33.z)) {
                    player.setDeltaMovement(vec33.x, (double)0.3f, vec33.z);
                }
            }
        }
    }

    private static int getHellStriderLevel(Player entity) {
        return entity.registryAccess().registry(Registries.ENCHANTMENT).flatMap(e -> e.getHolder(NDUEnchantments.HELL_STRIDER)).map(d -> EnchantmentHelper.getEnchantmentLevel((Holder)d, (LivingEntity)entity)).orElse(0);
    }

    @SubscribeEvent
    public static void changeFish(ItemFishedEvent event) {
        Player fisher = event.getEntity();
        ItemStack itemstack = fisher.getItemInHand(InteractionHand.MAIN_HAND);
        FishingHook bobber = event.getHookEntity();
        NonNullList drops = event.getDrops();
        if (bobber instanceof LavaFishingBobberEntity && ((Boolean)NetherDepthsUpgradeConfig.FISH_ENTITIES.get()).booleanValue()) {
            for (ItemStack stack : drops) {
                Entity entity = null;
                if (stack.getItem() == NDUItems.SEARING_COD.get()) {
                    entity = ((EntityType)NDUEntity.SEARING_COD.get()).create(event.getEntity().level());
                }
                if (stack.getItem() == NDUItems.SOULSUCKER.get()) {
                    entity = ((EntityType)NDUEntity.SOULSUCKER.get()).create(event.getEntity().level());
                }
                if (stack.getItem() == NDUItems.LAVA_PUFFERFISH.get()) {
                    entity = ((EntityType)NDUEntity.LAVA_PUFFERFISH.get()).create(event.getEntity().level());
                }
                if (stack.getItem() == NDUItems.BONEFISH.get()) {
                    entity = ((EntityType)NDUEntity.BONEFISH.get()).create(event.getEntity().level());
                }
                if (stack.getItem() == NDUItems.WITHER_BONEFISH.get()) {
                    entity = ((EntityType)NDUEntity.WITHER_BONEFISH.get()).create(event.getEntity().level());
                }
                if (stack.getItem() == NDUItems.GLOWDINE.get()) {
                    entity = ((EntityType)NDUEntity.GLOWDINE.get()).create(event.getEntity().level());
                }
                if (stack.getItem() == NDUItems.MAGMACUBEFISH.get()) {
                    entity = ((EntityType)NDUEntity.MAGMACUBEFISH.get()).create(event.getEntity().level());
                }
                if (stack.getItem() == NDUItems.OBSIDIANFISH.get()) {
                    entity = ((EntityType)NDUEntity.OBSIDIAN_FISH.get()).create(event.getEntity().level());
                }
                if (stack.getItem() == NDUItems.BLAZEFISH.get()) {
                    entity = ((EntityType)NDUEntity.BLAZEFISH.get()).create(event.getEntity().level());
                }
                if (stack.getItem() == NDUItems.EYEBALL_FISH.get()) {
                    entity = ((EntityType)NDUEntity.EYEBALL_FISH.get()).create(event.getEntity().level());
                }
                if (stack.getItem() == NDUItems.FORTRESS_GROUPER.get()) {
                    entity = ((EntityType)NDUEntity.FORTRESS_GROUPER.get()).create(event.getEntity().level());
                }
                if (entity == null) {
                    ItemEntity itementity = new ItemEntity(event.getEntity().level(), bobber.getX(), bobber.getY() + 1.0, bobber.getZ(), stack);
                    double d0 = fisher.position().x() - bobber.position().x();
                    double d1 = fisher.position().y() - (bobber.position().y() + 1.0);
                    double d2 = fisher.position().z() - bobber.position().z();
                    double d3 = 0.1;
                    itementity.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    event.getEntity().level().addFreshEntity((Entity)itementity);
                    fisher.level().addFreshEntity((Entity)new ExperienceOrb(fisher.level(), fisher.getX(), fisher.getY() + 0.5, fisher.getZ() + 0.5, bobber.level().random.nextInt(6) + 1));
                    CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)fisher, itemstack, bobber, (Collection)drops);
                    if (itemstack.is(ItemTags.FISHES)) {
                        fisher.awardStat(Stats.FISH_CAUGHT, 1);
                    }
                    event.setCanceled(true);
                    event.damageRodBy(event.getRodDamage());
                    return;
                }
                entity.moveTo(bobber.position().x(), bobber.position().y(), bobber.position().z(), bobber.xRotO, bobber.yRotO);
                double dX = fisher.position().x() - bobber.position().x();
                double dY = fisher.position().y() - bobber.position().y();
                double dZ = fisher.position().z() - bobber.position().z();
                double mult = 0.12;
                entity.setDeltaMovement(dX * mult, dY * mult + Math.sqrt(Math.sqrt(dX * dX + dY * dY + dZ * dZ)) * 0.14, dZ * mult);
                event.getEntity().level().addFreshEntity(entity);
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)fisher, itemstack, bobber, (Collection)drops);
                if (!itemstack.is(ItemTags.FISHES)) continue;
                fisher.awardStat(Stats.FISH_CAUGHT, 1);
            }
            event.setCanceled(true);
            event.damageRodBy(event.getRodDamage());
        }
    }

    @SubscribeEvent
    public static void frogFeed(PlayerInteractEvent.EntityInteract event) {
        if (event.getLevel().isClientSide || !(event.getTarget() instanceof Frog) || !(event.getEntity() instanceof Player)) {
            return;
        }
        Frog frog = (Frog)event.getTarget();
        Player player = event.getEntity();
        Level level = event.getLevel();
        ItemStack itemStack_ochre = new ItemStack((ItemLike)Items.OCHRE_FROGLIGHT);
        ItemStack itemStack_pearlescent = new ItemStack((ItemLike)Items.PEARLESCENT_FROGLIGHT);
        ItemStack itemStack_verdant = new ItemStack((ItemLike)Items.VERDANT_FROGLIGHT);
        ItemEntity itemEntity_ochre = new ItemEntity(level, frog.getX(), frog.getY(), frog.getZ(), itemStack_ochre);
        ItemEntity itemEntity_pearlescent = new ItemEntity(level, frog.getX(), frog.getY(), frog.getZ(), itemStack_pearlescent);
        ItemEntity itemEntity_verdant = new ItemEntity(level, frog.getX(), frog.getY(), frog.getZ(), itemStack_verdant);
        ItemStack itemInHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemInHand.getItem() == ((Item)NDUItems.MAGMACUBEFISH.get()).asItem()) {
            if (frog.getVariant() == FrogVariant.COLD) {
                level.addFreshEntity((Entity)itemEntity_verdant);
            }
            if (frog.getVariant() == FrogVariant.TEMPERATE) {
                level.addFreshEntity((Entity)itemEntity_ochre);
            }
            if (frog.getVariant() == FrogVariant.WARM) {
                level.addFreshEntity((Entity)itemEntity_pearlescent);
            }
            if (!player.isCreative()) {
                level.playSound(null, frog.blockPosition(), SoundEvents.FROG_EAT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                itemInHand.setCount(itemInHand.getCount() - 1);
            }
        }
    }
}

