/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.entities;

import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import com.scouter.netherdepthsupgrade.entity.ai.FishSwimGoal;
import com.scouter.netherdepthsupgrade.items.NDUItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SoulSuckerEntity
extends AbstractLavaFish
implements GeoEntity {
    private static final EntityDataAccessor<BlockPos> SOULSAND_POS = SynchedEntityData.defineId(SoulSuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Integer> SEEK_SOULSAND_TIMER = SynchedEntityData.defineId(SoulSuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COOLDOWN_TTIMER = SynchedEntityData.defineId(SoulSuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final RawAnimation MOVING_SOULSUCKER = RawAnimation.begin().thenLoop("soulsucker.moving");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Logger LOGGER = LogUtils.getLogger();
    public int suckTimer = 0;
    @Nullable
    protected FishSwimGoal fishSwimGoal;

    public SoulSuckerEntity(EntityType<? extends AbstractLavaFish> p_27523_, Level p_27524_) {
        super(p_27523_, p_27524_);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.fishSwimGoal = new FishSwimGoal(this);
        this.goalSelector.addGoal(1, (Goal)new FindSoulSandGoal3(this));
        this.goalSelector.addGoal(4, (Goal)this.fishSwimGoal);
        this.fishSwimGoal.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.getCooldownTimer() > 0) {
            this.setSeekSoulSandTimer(this.getSeekSoulSandTimer() - 1);
            this.setCooldownTimer(this.getSeekSoulSandTimer());
        }
        ++this.suckTimer;
        BlockPos blockPos = BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ());
        if (this.level().getBlockState(blockPos.below()).is(Blocks.SOUL_SAND) || this.level().getBlockState(blockPos).is(Blocks.SOUL_SAND) && this.isInLava()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SOUL, this.getRandomX(0.6), this.getY(), this.getRandomZ(0.6), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)NDUItems.SOULSUCKER_BUCKET.get());
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_MOOD.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundEvents.SOUL_ESCAPE.value();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.SOUL_SAND_HIT;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.SOUL_SAND_FALL;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "soulsucker.moving", 0, state -> state.setAndContinue(MOVING_SOULSUCKER)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(SOULSAND_POS, (Object)BlockPos.ZERO);
        pBuilder.define(SEEK_SOULSAND_TIMER, (Object)0);
        pBuilder.define(COOLDOWN_TTIMER, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("SoulSandPosX", this.getSoulSandPos().getX());
        pCompound.putInt("SoulSandPosY", this.getSoulSandPos().getY());
        pCompound.putInt("SoulSandPosZ", this.getSoulSandPos().getZ());
        pCompound.putInt("seeksoulsandtimer", this.getSeekSoulSandTimer().intValue());
        pCompound.putInt("cooldowntimer", this.getCooldownTimer().intValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        int i = pCompound.getInt("SoulSandPosX");
        int j = pCompound.getInt("SoulSandPosY");
        int k = pCompound.getInt("SoulSandPosZ");
        this.setSoulsandPos(new BlockPos(i, j, k));
        this.setSeekSoulSandTimer(pCompound.getInt("seeksoulsandtimer"));
        this.setCooldownTimer(pCompound.getInt("cooldowntimer"));
        super.readAdditionalSaveData(pCompound);
    }

    public void setSoulsandPos(BlockPos pPos) {
        this.entityData.set(SOULSAND_POS, (Object)pPos);
    }

    public BlockPos getSoulSandPos() {
        return (BlockPos)this.entityData.get(SOULSAND_POS);
    }

    public void setSeekSoulSandTimer(Integer time) {
        this.entityData.set(SEEK_SOULSAND_TIMER, (Object)time);
    }

    public Integer getSeekSoulSandTimer() {
        return (Integer)this.entityData.get(SEEK_SOULSAND_TIMER);
    }

    public void setCooldownTimer(Integer time) {
        this.entityData.set(COOLDOWN_TTIMER, (Object)time);
    }

    public Integer getCooldownTimer() {
        return (Integer)this.entityData.get(COOLDOWN_TTIMER);
    }

    public static boolean checkDistance(BlockPos entityPos, BlockPos blockPos) {
        double z2;
        double z1;
        double z12;
        double y2;
        double y1;
        double y12;
        double x2;
        double x1 = entityPos.getX();
        double x12 = x1 - (x2 = (double)blockPos.getX());
        double disTot = x12 * x12 + (y12 = (y1 = (double)entityPos.getY()) - (y2 = (double)blockPos.getY())) * y12 + (z12 = (z1 = (double)entityPos.getZ()) - (z2 = (double)entityPos.getZ())) * z12;
        return disTot <= 3.0;
    }

    static class FindSoulSandGoal3
    extends Goal {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final SoulSuckerEntity mob;
        private int i = 0;
        private int counter = 0;
        private int suckCounter = 30;
        private BlockPos lastPos;
        private RandomSource rand = RandomSource.create();
        public final List<BlockPos> soulSandList = new ArrayList<BlockPos>();
        private boolean stuck;

        public FindSoulSandGoal3(SoulSuckerEntity mob) {
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.mob.isInLava() && !this.mob.level().getBlockState(this.mob.blockPosition().below()).is(Blocks.SOUL_SAND) && this.mob.getSeekSoulSandTimer() == 0;
        }

        public boolean canContinueToUse() {
            BlockPos blockpos = this.mob.getSoulSandPos();
            return this.mob.getSeekSoulSandTimer() == 0;
        }

        public void start() {
            if (this.mob.level() instanceof ServerLevel) {
                this.mob.getNavigation().stop();
                for (int x = -5; x < 5; ++x) {
                    for (int y = 0; y < 10; ++y) {
                        for (int z = -5; z < 5; ++z) {
                            double posX = this.mob.blockPosition().getX();
                            double posY = this.mob.blockPosition().getY();
                            double posZ = this.mob.blockPosition().getZ();
                            BlockPos blockPos = BlockPos.containing((double)(posX - (double)x), (double)(posY - (double)y), (double)(posZ - (double)z));
                            if (!this.mob.level().getBlockState(blockPos).is(Blocks.SOUL_SAND) || !this.mob.level().getFluidState(blockPos.above()).is((Fluid)Fluids.LAVA) || this.mob.level().getFluidState(blockPos.below()).is((Fluid)Fluids.LAVA) || !this.mob.level().getBlockState(blockPos.north()).is(Blocks.SOUL_SAND) || !this.mob.level().getBlockState(blockPos.east()).is(Blocks.SOUL_SAND) || !this.mob.level().getBlockState(blockPos.south()).is(Blocks.SOUL_SAND) || !this.mob.level().getBlockState(blockPos.west()).is(Blocks.SOUL_SAND)) continue;
                            this.soulSandList.add(blockPos);
                        }
                    }
                }
                if (this.soulSandList.size() > 0) {
                    this.mob.getNavigation().moveTo((double)this.soulSandList.get(this.i).getX(), (double)this.soulSandList.get(this.i).getY() + 0.5, (double)this.soulSandList.get(this.i).getZ(), 1.0);
                } else {
                    this.mob.setSeekSoulSandTimer(500);
                    this.mob.setCooldownTimer(this.mob.getSeekSoulSandTimer());
                    this.mob.fishSwimGoal.trigger();
                    this.stop();
                }
            }
        }

        public void stop() {
            BlockPos blockpos = this.mob.getSoulSandPos();
            super.stop();
            this.mob.setSeekSoulSandTimer(500);
            this.mob.setCooldownTimer(this.mob.getSeekSoulSandTimer());
            this.mob.fishSwimGoal.trigger();
            this.soulSandList.clear();
            this.suckCounter = 0;
            this.counter = 0;
            this.i = 0;
        }

        public void tick() {
            super.tick();
            this.lastPos = this.mob.blockPosition();
            if (this.soulSandList.size() == 0 || this.i >= this.soulSandList.size()) {
                this.stop();
                this.mob.fishSwimGoal.trigger();
                return;
            }
            if (!this.mob.level().getBlockState(this.soulSandList.get(this.i)).is(Blocks.SOUL_SAND) && this.counter < this.soulSandList.size()) {
                ++this.i;
                ++this.counter;
            }
            if (this.soulSandList.size() == 0 || this.i >= this.soulSandList.size()) {
                this.stop();
                this.mob.fishSwimGoal.trigger();
                return;
            }
            if ((this.mob.level().getBlockState(this.mob.blockPosition().below()).is(Blocks.SOUL_SAND) || this.mob.level().getBlockState(this.mob.blockPosition().below()).is(Blocks.SOUL_SOIL)) && SoulSuckerEntity.checkDistance(this.mob.blockPosition(), this.soulSandList.get(this.i))) {
                ++this.suckCounter;
                this.mob.getNavigation().moveTo((double)this.soulSandList.get(this.i).getX(), (double)this.soulSandList.get(this.i).getY() + 0.5, (double)this.soulSandList.get(this.i).getZ(), 1.0);
                if (this.suckCounter == 100) {
                    if (!this.mob.level().getBlockState(this.mob.blockPosition()).is(Blocks.SOUL_SAND)) {
                        this.mob.level().setBlock(this.mob.blockPosition().below(), Blocks.SOUL_SOIL.defaultBlockState(), 3);
                    } else {
                        this.mob.level().setBlock(this.mob.blockPosition(), Blocks.SOUL_SOIL.defaultBlockState(), 3);
                    }
                    this.mob.invulnerableTime = 30;
                    ++this.i;
                    ++this.counter;
                }
            } else {
                this.mob.getNavigation().moveTo((double)this.soulSandList.get(this.i).getX(), (double)(this.soulSandList.get(this.i).getY() + 1), (double)this.soulSandList.get(this.i).getZ(), 1.0);
            }
            if (this.suckCounter >= 100) {
                if (this.counter < this.soulSandList.size()) {
                    this.mob.getNavigation().moveTo((double)this.soulSandList.get(this.i).getX(), (double)this.soulSandList.get(this.i).getY() + 0.5, (double)this.soulSandList.get(this.i).getZ(), 1.0);
                } else {
                    BlockPos blockPos = new BlockPos(this.mob.blockPosition().getX() + this.rand.nextInt(-5, 5), this.mob.blockPosition().getY() + this.rand.nextInt(0, 3), this.mob.blockPosition().getZ() + this.rand.nextInt(-5, 5));
                    if (this.mob.level().getFluidState(blockPos).is((Fluid)Fluids.LAVA)) {
                        this.mob.getNavigation().moveTo((double)(this.mob.blockPosition().getX() + this.rand.nextInt(-5, 5)), (double)(this.mob.blockPosition().getY() + this.rand.nextInt(0, 3)), (double)(this.mob.blockPosition().getZ() + this.rand.nextInt(-5, 5)), 1.0);
                    }
                    this.mob.setSeekSoulSandTimer(500);
                    this.stop();
                }
                this.suckCounter = 0;
            }
        }
    }
}

